% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbi_01.R
\name{tbi_01}
\alias{tbi_01}
\title{TBI-01 Calculation}
\usage{
tbi_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  transport_disposition_col,
  evitals_06_col,
  evitals_12_col,
  evitals_16_col,
  evitals_23_col,
  evitals_26_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing the patient data.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name in df with the patient’s unique record ID.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column name in df with the patient’s age value.}

\item{epatient_16_col}{Column name in df with the patient’s age unit (e.g.,
years, months).}

\item{eresponse_05_col}{Column name in df with response codes for the type of
EMS call.}

\item{esituation_11_col}{Column name in df with the primary provider
impression.}

\item{esituation_12_col}{Column name in df with the secondary provider
impression.}

\item{transport_disposition_col}{Column name in df with the transport
disposition.}

\item{evitals_06_col}{Column name in df with systolic blood pressure (SBP).}

\item{evitals_12_col}{Column name in df with pulse oximetry values.}

\item{evitals_16_col}{Column name in df with ETCO2 values.
values.}

\item{evitals_23_col}{Column name in df with Glasgow Coma Scale (GCS) scores.}

\item{evitals_26_col}{Column name in df with AVPU (alert, verbal, painful,
unresponsive) values.}

\item{...}{Additional parameters passed to \code{dplyr::summarize} or other dplyr
functions.}
}
\value{
A tibble summarizing results for three population groups (Adults, and
Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (Adults, Peds).
\code{numerator}: Count of incidents where SP02, ETCO2, and SBP were all
measured.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where SP02, ETCO2, and SBP were all
measured.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function screens for potential traumatic brain injury (TBI) cases based
on specific criteria in a patient dataset. It produces a subset of the data
with calculated variables for TBI identification.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_11 = c(rep("S02", 3), rep("S06", 2)),
    esituation_12 = c(rep("S09.90", 2), rep("S06.0X9", 3)),
    evitals_06 = c(85, 80, 100, 90, 82),
    evitals_12 = c(95, 96, 97, 98, 99),
    evitals_16 = c(35, 36, 37, 38, 39),
    evitals_23 = rep(8, 5),
    evitals_26 = c("Verbal", "Painful", "Unresponsive", "Verbal", "Painful"),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

  # Run function
  tbi_01(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_11_col = esituation_11,
    esituation_12_col = esituation_12,
    evitals_06_col = evitals_06,
    evitals_12_col = evitals_12,
    evitals_16_col = evitals_16,
    evitals_23_col = evitals_23,
    evitals_26_col = evitals_26,
    transport_disposition_col = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
