% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypoglycemia_01_population.R
\name{hypoglycemia_01_population}
\alias{hypoglycemia_01_population}
\title{Hypoglycemia-01 Populations}
\usage{
hypoglycemia_01_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  medications_table = NULL,
  procedures_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  evitals_18_col,
  evitals_23_col,
  evitals_26_col,
  emedications_03_col,
  eprocedures_03_col
)
}
\arguments{
\item{df}{A data frame or tibble containing emergency response records.
Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing at least the
esituation fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing at least the evitals
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{medications_table}{A data.frame or tibble containing at least the
emedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{procedures_table}{A data.frame or tibble containing at least the
eprocedures fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{Column representing the unique record identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient's numeric age agnostic
of unit.}

\item{epatient_16_col}{Column representing the patient's age unit ("Years",
"Months", "Days", "Hours", or "Minute").}

\item{eresponse_05_col}{Column containing response type codes.}

\item{esituation_11_col}{Column for primary impression fields, containing
ICD-10 codes.}

\item{esituation_12_col}{Column for secondary impression fields, containing
ICD-10 codes.}

\item{evitals_18_col}{Column for blood glucose levels.}

\item{evitals_23_col}{Column for Glasgow Coma Scale (GCS) scores.}

\item{evitals_26_col}{Column for AVPU alertness levels.}

\item{emedications_03_col}{Column for administered medications.}

\item{eprocedures_03_col}{Column for procedures performed.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Hypoglycemia-01, and
categorizes records to identify needed information for the calculations.

Identifies key categories related to diabetes/hypoglycemia incidents in an
EMS dataset, specifically focusing on cases where 911 was called for
diabetes/hypoglycemia distress, certain medications were administered, and a
weight is taken. This function segments the data into pediatric populations,
computing the proportion of cases that have a documented weight.
}
\examples{

# create tables to test correct functioning

# patient table
patient_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  incident_date = as.Date(c("2025-01-01", "2025-01-05", "2025-02-01",
  "2025-01-01", "2025-06-01")),
  patient_dob = as.Date(c("2000-01-01", "2020-01-01", "2023-02-01",
  "2023-01-01", "1970-06-01")),
  epatient_15 = c(25, 5, 2, 2, 55),  # Ages
  epatient_16 = c("Years", "Years", "Years", "Years", "Years")

)

# response table
response_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  eresponse_05 = rep(2205001, 5)

)

# situation table
situation_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  esituation_11 = c(rep("E13.64", 3), rep("E16.2", 2)),
  esituation_12 = c(rep("E13.64", 2), rep("E16.2", 3))
)

# medications table
medications_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  emedications_03 = c(372326, 376937, 377980, 4850, 4832),

)

# vitals table
vitals_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  evitals_18 = c(60, 59, 58, 57, 56),
  evitals_23 = c(16, 15, 14, 13, 12),
  evitals_26 = c("Alert", "Painful", "Verbal", "Unresponsive", "Alert")

)

# procedures table
procedures_table <- tibble::tibble(

  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  eprocedures_03 = rep("710925007", 5)

)

# test the success of the function
result <- hypoglycemia_01_population(patient_scene_table = patient_table,
                            response_table = response_table,
                            situation_table = situation_table,
                            medications_table = medications_table,
                            vitals_table = vitals_table,
                            procedures_table = procedures_table,
                            erecord_01_col = erecord_01,
                            incident_date_col = incident_date,
                            patient_DOB_col = patient_dob,
                            epatient_15_col = epatient_15,
                            epatient_16_col = epatient_16,
                            eresponse_05_col = eresponse_05,
                            esituation_11_col = esituation_11,
                            esituation_12_col = esituation_12,
                            emedications_03_col = emedications_03,
                            evitals_18_col = evitals_18,
                            evitals_23_col = evitals_23,
                            evitals_26_col = evitals_26,
                            eprocedures_03_col = eprocedures_03
                            )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
