% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_02_population.R
\name{safety_02_population}
\alias{safety_02_population}
\title{Safety-02 Populations}
\usage{
safety_02_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  disposition_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  edisposition_18_col,
  edisposition_28_col,
  transport_disposition_cols
)
}
\arguments{
\item{df}{A data frame where each row is an observation, and each column
represents a feature.}

\item{patient_scene_table}{A data.frame or tibble containing only epatient
and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing only the eresponse
fields needed for this measure's calculations.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column giving response codes, identifying 911
responses.}

\item{edisposition_18_col}{Column giving transport mode descriptors,
including possible lights-and-sirens indicators.}

\item{edisposition_28_col}{Column giving patient evaluation and care
categories for the EMS response.}

\item{transport_disposition_cols}{One or more unquoted column names (such as
edisposition.12, edisposition.30) containing transport disposition details.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Safety-02, and categorizes
records to identify needed information for the calculations.

Identifies key categories related to a 911 request during which lights and
sirens were not used during patient transport. This function segments the
data by age into adult and pediatric populations.
}
\examples{

# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5)

  )

  # disposition table
  disposition_table <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    edisposition_18 = rep(4218015, 5),
    edisposition_28 = rep(4228001, 5),
    edisposition_30 = rep(4230001, 5)
  )

  # test the success of the function
  result <- safety_02_population(patient_scene_table = patient_table,
                        response_table = response_table,
                        disposition_table = disposition_table,
                        erecord_01_col = erecord_01,
                        incident_date_col = incident_date,
                        patient_DOB_col = patient_dob,
                        epatient_15_col = epatient_15,
                        epatient_16_col = epatient_16,
                        eresponse_05_col = eresponse_05,
                        edisposition_18_col = edisposition_18,
                        edisposition_28_col = edisposition_28,
                        transport_disposition_cols = edisposition_30
                        )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
