% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDatatable.R
\name{getDatatable}
\alias{getDatatable}
\title{Get NEON data table}
\usage{
getDatatable(dpid = "DP1.10086.001",
  data_table_name = "sls_soilCoreCollection",
  sample_location_list = NA, sample_location_type = "siteID",
  sample_date_min = "2012-01-01", sample_date_max = Sys.Date(),
  sample_date_format = "\%Y-\%m-\%d", data_package_type = "basic",
  url_prefix_data = "http://data.neonscience.org:80/api/v0/data/",
  url_prefix_products = "http://data.neonscience.org:80/api/v0/products/")
}
\arguments{
\item{dpid}{character sting for NEON data product ID}

\item{data_table_name}{character sting for name of the data table to download, e.g., 'sls_soilCoreCollection' (with or without the _pub suffix)}

\item{sample_location_list}{list of sites, domains, etc. If NA, retrieve all data for the given data table / dpid combination.}

\item{sample_location_type}{character sting for location type, such as 'siteID'. Must be one of the NEON controlled terms. If you're unsure, use 'siteID'}

\item{sample_date_min}{start date for query. Default is 1-Jan-2012, and this should capture the earliest NEON data record.}

\item{sample_date_max}{end date for query. Default is current date.}

\item{sample_date_format}{date format. Default/expected format is yyyy-mm-dd}

\item{data_package_type}{package type, either 'basic' or 'expanded'. If unsure, use 'expanded'}

\item{url_prefix_data}{data endpoint for NEON API.}

\item{url_prefix_products}{products endpoint for NEON API.}
}
\value{
data frame with selected NEON data
}
\description{
This is a function to retrieve a data table
from the NEON data portal for sites and dates provided by the
enduser.
}
\examples{
sls_soilCoreCollection <- getDatatable(
  sample_location_list = c('CPER','TALL'),
  sample_date_min = '2014-01-01',
  sample_date_max = '2014-06-01',
  dpid = "DP1.10086.001",
  data_table_name = 'sls_soilCoreCollection')


}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Eric R. Sokol \email{esokol@battelleecology.org}
}
