% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{glmnet_filter}
\alias{glmnet_filter}
\title{glmnet filter}
\usage{
glmnet_filter(
  y,
  x,
  nfilter = NULL,
  method = c("mean", "nonzero"),
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{nfilter}{Number of predictors to return}

\item{method}{String indicating method of determining variable importance.
"mean" (the default) uses the mean absolute coefficients across the range
of lambdas; "nonzero" counts the number of times variables are retained in
the model across all values of lambda.}

\item{type}{Type of vector returned. Default "index" returns indices, "names"
returns predictor names, "full" returns full output.}

\item{...}{Other arguments passed to \link{glmnet}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} a named vector of variable importance is returned.
}
\description{
Filter using properties of elastic net regression using glmnet to calculate
variable importance.
}
\details{
The glmnet elastic net mixing parameter alpha can be varied to
include a larger number of predictors. Default alpha = 1 is pure LASSO,
resulting in greatest sparsity, while alpha = 0 is pure ridge regression,
retaining all predictors in the regression model. Note, the \code{family}
argument is commonly needed, see \link{glmnet}.
}
\seealso{
\link{glmnet}
}
