% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{barplot_var_stability}
\alias{barplot_var_stability}
\title{Barplot variable stability}
\usage{
barplot_var_stability(
  x,
  final = TRUE,
  top = 25,
  direction = 0,
  dir_labels = NULL,
  breaks = NULL,
  percent = TRUE,
  level = 1,
  sort = TRUE
)
}
\arguments{
\item{x}{a \code{nestcv.glmnet} or \code{nestcv.train} fitted object}

\item{final}{Logical whether to restrict variables to only those which ended
up in the final fitted model or to include all variables selected across
all outer folds.}

\item{top}{Limits number of variables plotted. Ignored if \code{final = TRUE}.}

\item{direction}{Integer controlling plotting of directionality for binary or
regression models. \code{0} means no directionality is shown, \code{1} means
directionality is overlaid as a colour, \code{2} means directionality is
reflected in the sign of variable importance.}

\item{dir_labels}{Character vector for controlling the legend when
\code{direction = 1}}

\item{breaks}{Vector of continuous breaks for legend colour/size}

\item{percent}{Logical for \code{nestcv.glmnet} objects only, whether to scale
coefficients to percentage of the largest coefficient in each model. If set
to \code{FALSE}, model coefficients are shown and \code{direction} is ignored.}

\item{level}{For multinomial \code{nestcv.glmnet} models only, either an integer
specifying which level of outcome is being examined, or the level can be
specified as a character value.}

\item{sort}{Logical whether to sort by mean variable importance. Passed to
\code{\link[=var_stability]{var_stability()}}.}
}
\value{
A ggplot2 plot
}
\description{
Produces a ggplot2 plot of stability (as SEM) of variable importance across
models trained and tested across outer CV folds. Optionally overlays
directionality for binary response or regression outcomes.
}
\seealso{
\code{\link[=var_stability]{var_stability()}}
}
