% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{rf_filter}
\alias{rf_filter}
\title{Random forest filter}
\usage{
rf_filter(
  y,
  x,
  nfilter = NULL,
  type = c("index", "names", "full"),
  ntree = 1000,
  mtry = ncol(x) * 0.2,
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors are
returned.}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a named vector of variable
importance.}

\item{ntree}{Number of trees to grow. See \link[randomForest:randomForest]{randomForest::randomForest}.}

\item{mtry}{Number of predictors randomly sampled as candidates at each
split. See \link[randomForest:randomForest]{randomForest::randomForest}.}

\item{...}{Optional arguments passed to \link[randomForest:randomForest]{randomForest::randomForest}.}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} a named vector of variable importance is returned.
}
\description{
Fits a random forest model and ranks variables by variable importance.
}
\details{
This filter uses the \code{randomForest()} function from the \code{randomForest}
package. Variable importance is calculated using the
\link[randomForest:importance]{randomForest::importance} function, specifying type 1 = mean decrease in
accuracy. See \link[randomForest:importance]{randomForest::importance}.
}
