% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\title{Model performance metrics}
\usage{
metrics(object, extra = FALSE, innerCV = FALSE, positive = 2)
}
\arguments{
\item{object}{A 'nestcv.glmnet', 'nestcv.train', 'nestcv.SuperLearner' or
'outercv' object.}

\item{extra}{Logical whether additional performance metrics are gathered for
binary classification models: area under precision recall curve (PR.AUC),
Cohen's kappa, F1 score, Matthew's correlation coefficient (MCC).}

\item{innerCV}{Whether to calculate metrics for inner CV folds. Only
available for 'nestcv.glmnet' and 'nestcv.train' objects.}

\item{positive}{For binary classification, either an integer 1 or 2 for the
level of response factor considered to be 'positive' or 'relevant', or a
character value for that factor. This affects the F1 score. See
\code{\link[caret:confusionMatrix]{caret::confusionMatrix()}}.}
}
\value{
A named numeric vector of performance metrics.
}
\description{
Returns model metrics from nestedcv models. Extended metrics including
}
\details{
Area under precision recall curve is estimated by trapezoidal estimation
using \code{MLmetrics::PRAUC()}.
}
