% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGibbs.R
\name{simGibbs}
\alias{simGibbs}
\title{Generate binary (\strong{Y}, \strong{A}, \strong{C}) from chain graph model under simplest scenario.}
\usage{
simGibbs(n.unit, n.gibbs, n.sample, weight.matrix, treat.matrix,
  cov.matrix, init.prob = 0.5, treat.prob = 0.5, cov.prob = 0.5,
  n.burn = 100, yvalues = c(1, 0))
}
\arguments{
\item{n.unit}{the number of units (\code{m}).}

\item{n.gibbs}{the number of independent Gibbs sampler.}

\item{n.sample}{the number of samples from each Gibbs sampling (\code{n} = \code{n.gibbs} x \code{n.sample}).}

\item{weight.matrix}{a \code{[m x m]} symmetric relational matrix where \eqn{W_ij = 1} indicates the existence of undirected edges between \eqn{Y_i} and \eqn{Y_j} and its magnitude. Here \eqn{W_ii} represents the main effect of \eqn{Y_i}.}

\item{treat.matrix}{a \code{[m x m]} matrix where \eqn{treat.matrix_ij} indicates the magnitude of direct effect from \eqn{A_i} to \eqn{Y_j}.}

\item{cov.matrix}{a \code{[m x m]} matrix where \eqn{treat.matrix_ij} indicates the magnitude of direct effect from \eqn{C_i} to \eqn{Y_j}.}

\item{init.prob}{an initial probability generating (\strong{Y}, \strong{A}, \strong{C}) from Bernoulli distribution.}

\item{treat.prob}{a probability updating \strong{A} in Gibbs sampling procedure.}

\item{cov.prob}{a probability updating \strong{C} in Gibbs sampling procedure.}

\item{n.burn}{the number of burn-in sample in Gibbs sampling (\eqn{\ge} \code{n.obs}).}

\item{yvalues}{a vector of distinct binary outcome values. Defaults to \code{c(0,1)}.}
}
\value{
a list of \code{[n.gibbs] x [n.sample]} independent observations:
\item{\code{inputY}}{a \code{[([n.gibbs] x [n.sample]) x m]} matrix for outcomes.}
\item{\code{inputA}}{a \code{[([n.gibbs] x [n.sample]) x m]} matrix for treatments.}
\item{\code{inputC}}{a \code{[([n.gibbs] x [n.sample]) x m]} matrix for confounders.}
}
\description{
Generate binary (\strong{Y}, \strong{A}, \strong{C}) from chain graph model under simplest scenario.
}
\examples{
library(netchain)
weight.matrix <- matrix(c(0.5, 1, 0, 1, 0.3, 0.5, 0, 0.5, -0.5), 3, 3)
simobs <- simGibbs(n.unit = 3, n.gibbs = 200, n.sample = 10, 
                  weight.matrix,
                  treat.matrix = 0.5*diag(3), cov.matrix= (-0.3)*diag(3) )
inputY <- simobs$inputY
inputA <- simobs$inputA
inputC <- simobs$inputC

}
