% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{nvertices}
\alias{nedges}
\alias{nlinks}
\alias{nnodes}
\alias{nslices}
\alias{nvertices}
\title{Count the number of vertices/edges/slices in a graph}
\usage{
nvertices(graph)

nnodes(graph)

nedges(graph)

nlinks(graph)

nslices(graph)
}
\arguments{
\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}
}
\value{
For \code{nvertices} and \code{nslices}, an integer scalar equal to the number
of vertices and slices in the graph. Otherwise, from \code{nedges}, either a list
of size \eqn{t} with the counts of edges (non-zero elements in the adjacency matrices) at
each time period, or, when \code{graph} is static, a single scalar with
such number.
}
\description{
Count the number of vertices/edges/slices in a graph
}
\details{
\code{nnodes} and \code{nlinks} are just aliases for \code{nvertices} and
\code{nedges} respectively.
}
\examples{
# Creating a dynamic graph (we will use this for all the classes) -----------
set.seed(13133)
diffnet <- rdiffnet(100, 4)

# Lets use the first time period as a static graph
graph_mat <- diffnet$graph[[1]]
graph_dgCMatrix <- methods::as(graph_mat, "dgCMatrix")

# Now lets generate the other dynamic graphs
graph_list  <- diffnet$graph
graph_array <- as.array(diffnet) # using the as.array method for diffnet objects

# Now we can compare vertices counts
nvertices(diffnet)
nvertices(graph_list)
nvertices(graph_array)

nvertices(graph_mat)
nvertices(graph_dgCMatrix)

# ... and edges count
nedges(diffnet)
nedges(graph_list)
nedges(graph_array)

nedges(graph_mat)
nedges(graph_dgCMatrix)
}

