% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjmat.r
\name{toa_mat}
\alias{toa_mat}
\title{Time of adoption matrix}
\usage{
toa_mat(obj, labels = NULL, t0 = NULL, t1 = NULL)
}
\arguments{
\item{obj}{Either an integer vector of size \eqn{n} containing time of adoption of the innovation,
or a \code{\link{diffnet}} object.}

\item{labels}{Character vector of size \eqn{n}. Labels (ids) of the vertices.}

\item{t0}{Integer scalar. Sets the lower bound of the time window (e.g. 1955).}

\item{t1}{Integer scalar. Sets the upper bound of the time window (e.g. 2000).}
}
\value{
A list of two \eqn{n \times T}{n x T}
 \item{\code{cumadopt}}{has 1's for all years in which a node indicates having the innovation.}
 \item{\code{adopt}}{has 1's only for the year of adoption and 0 for the rest.}
}
\description{
Creates two matrices recording times of adoption of the innovation. One matrix
records the time period of adoption for each node with zeros elsewhere. The
second records the cumulative time of adoption such that there are ones for
the time of adoption and every time period thereafter.
}
\details{
In order to be able to work with time ranges other than \eqn{1,\dots, T}{1,..., T}
the function receives as input the boundary labels of the time windows through
the variables \code{t0} and \code{t}. While by default the function assumes that
the the boundaries are given by the range of the \code{times} vector, the user
can set a personalized time range exceeding the one given by the \code{times}
vector. For instance, times of adoption may range between 2001 and 2005 but the
actual data, the network, is observed between 2000 and 2005 (so there is not
left censoring in the data), hence, the user could write:

\preformatted{
adopmats <- toa_mat(times, t0=2000, t1=2005)
}

That way the resulting \code{cumadopt} and \code{adopt} matrices would have
2005 - 2000 + 1 = 6 columns instead of 2005 - 2001 + 1 = 5 columns, with the
first column of the two matrices containing only zeros (as the first adoption
happend after the year 2000).
}
\examples{
# Random set of times of adoptions
times <- sample(c(NA, 2001:2005), 10, TRUE)

toa_mat(times)

# Now, suppose that we observe the graph from 2000 to 2006
toa_mat(times, t0=2000, t1=2006)

}
\author{
George G. Vega Yon, Stephanie R. Dyal, Timothy B. Hayes & Thomas W. Valente
}
\keyword{manip}
