print.netmeta <- function(x,
                          sortvar,
                          comb.fixed = x$comb.fixed, comb.random = x$comb.random,
                          prediction = x$prediction,
                          reference.group = x$reference.group,
                          baseline.reference = x$baseline.reference,
                          all.treatments = x$all.treatments,
                          details = TRUE, ma = TRUE,
                          ##
                          backtransf = x$backtransf, nchar.trts = x$nchar.trts,
                          digits = gs("digits"),
                          digits.se = gs("digits.se"),
                          digits.pval.Q = max(gs("digits.pval.Q"), 2),
                          digits.Q = gs("digits.Q"),
                          digits.tau2 = gs("digits.tau2"),
                          digits.I2 = gs("digits.I2"),
                          scientific.pval = gs("scientific.pval"),
                          big.mark = gs("big.mark"),
                          ...
                          ) {
  
  
  meta:::chkclass(x, "netmeta")
  ##  
  x <- upgradenetmeta(x)
  ##
  formatN <- meta:::formatN
  formatCI <- meta:::formatCI
  chklogical <- meta:::chklogical
  chknumeric <- meta:::chknumeric
  
  
  chklogical(comb.fixed)
  chklogical(comb.random)
  chklogical(prediction)
  chklogical(baseline.reference)
  ##
  chklogical(backtransf)
  chknumeric(nchar.trts, min = 1, single = TRUE)
  ##
  chknumeric(digits, min = 0, single = TRUE)
  chknumeric(digits.se, min = 0, single = TRUE)
  chknumeric(digits.pval.Q, min = 1, single = TRUE)
  chknumeric(digits.Q, min = 0, single = TRUE)
  chknumeric(digits.tau2, min = 0, single = TRUE)
  chknumeric(digits.I2, min = 0, single = TRUE)
  ##
  chklogical(scientific.pval)
  
  
  ##
  ## Additional arguments
  ##
  fun <- "print.netmeta"
  addargs <- names(list(...))
  ##
  meta:::warnarg("logscale", addargs, fun, otherarg = "backtransf")
  
  
  if (!inherits(x, "netmetabin")) {
    k.all <- length(x$TE)
    ##
    if (missing(sortvar)) sortvar <- 1:k.all
    ##
    if (length(sortvar) != k.all)
      stop("'x' and 'sortvar' have different length")
    ##
    ci.lab <- paste(round(100 * x$level, 1), "%-CI", sep = "")
    
    sm <- x$sm
    
    sm.lab <- sm
    ##
    if (!backtransf & meta:::is.relative.effect(sm))
      sm.lab <- paste("log", sm, sep = "")
    
    
    trts <- rownames(x$TE.fixed)
    trts.abbr <- treats(trts, nchar.trts)
    ##
    treat1 <- as.character(factor(x$treat1, levels = trts, labels = trts.abbr))
    treat2 <- as.character(factor(x$treat2, levels = trts, labels = trts.abbr))
    ##
    if (any(treat1 != x$treat1) | any(treat2 != x$treat2))
      abbr <- c(treat1, treat2)
    else
      abbr <- NULL
    
    
    matitle(x)
    
    
    if (details) {

      cat(paste("Original data",
                ifelse(any(x$narms > 2),
                       " (with adjusted standard errors for multi-arm studies)",
                       ""),
                ":\n\n", sep = ""))
      
      res <- data.frame(treat1,
                        treat2,
                        TE = formatN(x$TE, digits, text.NA = "NA",
                                     big.mark = big.mark),
                        seTE = formatN(x$seTE, digits.se, text.NA = "NA",
                                       big.mark = big.mark))
      ##
      if (any(x$narms > 2))
        res$seTE.adj <- format(round(x$seTE.adj, digits.se))
      ##
      res$studlab <- x$studlab
      ##
      if (any(x$narms > 2)) {
        tdata1 <- data.frame(studlab = as.character(x$studies),
                             narms = x$narms)
        res$OrDeR <- 1:dim(res)[[1]]
        res <- merge(res, tdata1,
                     by = "studlab", all.x = TRUE, all.y = FALSE,
                     sort = FALSE)
        res <- res[order(res$OrDeR), ]
        res$multiarm <- ifelse(res$narms > 2, "*", "")
        res$OrDeR <- NULL
        res$studlab <- NULL
        res <- as.matrix(res)
      }
      else
        res$studlab <- NULL
      ##
      dimnames(res)[[1]] <- x$studlab
      
      prmatrix(res[order(sortvar), ],
               quote = FALSE, right = TRUE)
      cat("\n")
      
      cat("Number of treatment arms (by study):\n")
      prmatrix(data.frame(narms = x$narms, row.names = x$studies),
               quote = FALSE, right = TRUE)
      cat("\n")
    }
    
    
    tsum <- summary(x, warn = FALSE)
    ##
    TE.f    <- tsum$comparison.nma.fixed$TE
    lowTE.f <- tsum$comparison.nma.fixed$lower
    uppTE.f <- tsum$comparison.nma.fixed$upper
    ##
    if (backtransf & meta:::is.relative.effect(sm)) {
      TE.f    <- exp(TE.f)
      lowTE.f <- exp(lowTE.f)
      uppTE.f <- exp(uppTE.f)
    }
    ##
    ##
    TE.r    <- tsum$comparison.nma.random$TE
    lowTE.r <- tsum$comparison.nma.random$lower
    uppTE.r <- tsum$comparison.nma.random$upper
    ##
    if (backtransf & meta:::is.relative.effect(sm)) {
      TE.r    <- exp(TE.r)
      lowTE.r <- exp(lowTE.r)
      uppTE.r <- exp(uppTE.r)
    }
    
    
    res.f <- cbind(treat1, treat2,
                   formatN(TE.f, digits, text.NA = "NA", big.mark = big.mark),
                   formatCI(formatN(round(lowTE.f, digits), digits, "NA",
                                    big.mark = big.mark),
                            formatN(round(uppTE.f, digits), digits, "NA",
                                    big.mark = big.mark)),
                   if (comb.fixed)
                     formatN(round(x$Q.fixed, digits.Q), digits.Q, "NA",
                             big.mark = big.mark),
                   if (comb.fixed) format(round(x$leverage.fixed, 2)))
    dimnames(res.f) <-
      list(x$studlab, c("treat1", "treat2",
                        sm.lab, ci.lab,
                        if (comb.fixed) "Q",
                        if (comb.fixed) "leverage"))
    
    
    res.r <- cbind(treat1, treat2,
                   formatN(TE.r, digits, text.NA = "NA", big.mark = big.mark),
                   formatCI(formatN(round(lowTE.r, digits), digits, "NA",
                                    big.mark = big.mark),
                            formatN(round(uppTE.r, digits), digits, "NA",
                                    big.mark = big.mark)))
    dimnames(res.r) <-
      list(x$studlab, c("treat1", "treat2", sm.lab, ci.lab))
    
    
    if (comb.fixed) {
      cat("Results (fixed effect model):\n\n")
      
      prmatrix(res.f[order(sortvar), , drop = FALSE],
               quote = FALSE, right = TRUE)
      
      cat("\n")
    }
    
    if (comb.random) {
      cat("Results (random effects model):\n\n")
      
      prmatrix(res.r[order(sortvar), , drop = FALSE],
               quote = FALSE, right = TRUE)
      
      cat("\n")
    }
  }
  else {
    tsum <- summary(x, warn = FALSE)
    abbr <- NULL
  }
  
  
  if (reference.group != "" & missing(all.treatments))
    all.treatments <- FALSE
  
  
  if (reference.group != "")
    reference.group <- setref(reference.group, rownames(x$A.matrix))
  
  
  if (ma)
    print(tsum,
          comb.fixed = comb.fixed, comb.random = comb.random,
          prediction = prediction,
          backtransf = backtransf,
          reference.group = reference.group,
          baseline.reference = baseline.reference,
          all.treatments = all.treatments,
          header = FALSE, nchar.trts = nchar.trts,
          ##
          digits = digits,
          digits.pval.Q = digits.pval.Q,
          digits.Q = digits.Q,
          digits.tau2 = digits.tau2,
          digits.I2 = digits.I2,
          scientific.pval = scientific.pval,
          big.mark = big.mark)
  else
    if (!is.null(abbr)) {
      abbr <- unique(abbr)
      full <- unique(c(x$treat1, x$treat2))
      ##
      tmat <- data.frame(abbr, full)
      names(tmat) <- c("Abbreviation", "Treatment name")
      tmat <- tmat[order(tmat$Abbreviation), ]
      ##
      cat("Legend:\n")
      prmatrix(tmat, quote = FALSE, right = TRUE,
               rowlab = rep("", length(abbr)))
    }
  
  invisible(NULL)
}
