% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloring.R
\name{netplot-formulae}
\alias{netplot-formulae}
\alias{color_formula}
\alias{ego}
\alias{alter}
\title{Formulas in \code{netplot}}
\usage{
color_formula(x, col, alpha, env, type, mix = 1, postfix = NULL)

ego(...)

alter(...)
}
\arguments{
\item{x}{An object of class \link{netplot}.}

\item{col}{Any valid color. Can be a single color or a vector.}

\item{alpha}{Number. Alpha levels}

\item{env, type, postfix}{For internal use only.}

\item{mix}{Number. For mixing colors between \code{ego} and \code{alter}}

\item{...}{Passed to \code{color_formula}.}
}
\value{
Nothing. These functions are called internally when using
formulas. \code{color_formula} modifies the environment \code{env}.
}
\description{
Edge colors in both \code{\link[=nplot]{nplot()}} and \code{\link[=set_edge_gpar]{set_edge_gpar()}} can be specified using
a formula based on \code{ego()} and \code{alter()} (source and target). This way the
user can set various types of combination varying the mixing of the colors,
the alpha levels, and the actual mixing colors to create edge colors.
}
\examples{
if (require(gridExtra) & require(magrittr)) {
  library(igraph)
  net <- make_ring(4)

  set.seed(1)
  np <- nplot(net, vertex.color = grDevices::hcl.colors(4), vertex.size.range=c(.1, .1))
  np \%<>\% set_edge_gpar(lwd = 4)

  grid.arrange(
    np,
    np \%>\% set_edge_gpar(col =~ego + alter),
    np \%>\% set_edge_gpar(col =~ego(alpha=0) + alter),
    np \%>\% set_edge_gpar(col =~ego + alter(alpha=0)),
    np \%>\% set_edge_gpar(col =~ego(mix=0) + alter(mix=1)),
    np \%>\% set_edge_gpar(col =~ego(mix=1) + alter(mix=0))
  )
}
}
