% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot_base.R
\name{nplot_base}
\alias{nplot_base}
\title{\code{nplot} using base graphics}
\usage{
nplot_base(
  x,
  layout = igraph::layout_nicely(x),
  vertex.size = igraph::degree(x, mode = "in"),
  bg.col = "transparent",
  vertex.nsides = 10,
  vertex.color = grDevices::hcl.colors(1),
  vertex.size.range = c(0.01, 0.03),
  vertex.frame.color = grDevices::adjustcolor(vertex.color, red.f = 0.75, green.f = 0.75,
    blue.f = 0.75),
  vertex.rot = 0,
  vertex.frame.prop = 0.1,
  edge.width = NULL,
  edge.width.range = c(1, 2),
  edge.arrow.size = NULL,
  edge.color = NULL,
  edge.color.mix = 0.5,
  edge.color.alpha = c(0.1, 0.5),
  edge.curvature = pi/3,
  edge.line.lty = "solid",
  edge.line.breaks = 5,
  sample.edges = 1,
  skip.vertex = FALSE,
  skip.edges = FALSE,
  skip.arrows = skip.edges,
  add = FALSE,
  zero.margins = TRUE
)
}
\arguments{
\item{x}{A graph. It supports networks stored as \code{igraph}, \code{network}, and
matrices objects (see details).}

\item{layout}{Numeric two-column matrix with the graph layout in x/y positions of the vertices.}

\item{vertex.size}{Numeric vector of length \code{vcount(x)}. Absolute size of the vertex from 0 to 1.}

\item{bg.col}{Color of the background.}

\item{vertex.nsides}{Numeric vector of length \code{vcount(x)}. Number of sizes of
the vertex. E.g. three is a triangle, and 100 approximates a circle.}

\item{vertex.color}{Vector of length \code{vcount(x)}. Vertex HEX or built in colors.}

\item{vertex.size.range}{Vector of length \code{vcount(x)} from 0 to 1.}

\item{vertex.frame.color}{Vector of length \code{vcount(x)}. Border of vertex in HEX or built in colors.}

\item{vertex.rot}{Vector of length \code{vcount(x)} in Radians. Passed to \link{npolygon},
elevation degree from which the polygon is drawn.}

\item{vertex.frame.prop}{Vector of length \code{vcount(x)}. What proportion of the
vertex does the frame occupy (values between 0 and 1).}

\item{edge.width}{Vector of length \code{ecount(x)} from 0 to 1. All edges will be the same size.}

\item{edge.width.range}{Vector of length \code{ecount(x)} from 0 to 1. Adjusting width according to weight.}

\item{edge.arrow.size}{Vector of length \code{ecount(x)} from 0 to 1.}

\item{edge.color}{A vector of length \code{ecount(x)}. In HEX or built in colors. Can be \code{NULL} in which case
the color is picked as a mixture between ego and alters' \code{vertex.color} values.}

\item{edge.color.mix}{Proportion of the mixing.}

\item{edge.color.alpha}{Either a vector of length 1 or 2, or a matrix of
size \code{ecount(x)*2} with values in \verb{[0,1]}. Alpha (transparency) levels (see
details)}

\item{edge.curvature}{Numeric vector of length \code{ecount(x)}. Curvature of edges
in terms of radians.}

\item{edge.line.lty}{Vector of length \code{ecount(x)}. Line types in R (e.g.- 1 = Solid, 2 = Dashed, etc)}

\item{edge.line.breaks}{Vector of length \code{ecount(x)}. Number of vertices to
draw (approximate) the arc (edge).}

\item{sample.edges}{Numeric scalar between 0 and 1. Proportion of edges to sample.}

\item{skip.vertex, skip.edges, skip.arrows}{Logical scalar. When \code{TRUE} the object
is not plotted.}

\item{add}{Logical scalar.}

\item{zero.margins}{Logical scalar.}
}
\value{
\code{nplot_base} returns a list with the following components:
\itemize{
\item \code{vertex.coords} A list of length \code{N} where each element describes the
geomtry of each vertex.
\item \code{vertex.color} A vector of colors
\item \code{vertex.frame.coords} Similar to \code{vertex.coords}, but for the frame.
\item \code{vertex.frame.color} Similar to \code{vertex.color}, but for the frame.
\item \code{edge.color} Vector of functions used to compute the edge colors.
\item \code{edge.coords} Similar to \code{vertex.coords}, the points that describe each
edge.
\item \code{edge.arrow.coords} A list of matrices describing the geometry of the
tip of the edges.
\item \code{edge.width} A numeric vector with edges' widths.
\item \code{xlim}, \code{ylim} Limits of the plot area.
}
}
\description{
\code{nplot} using base graphics
}
\examples{
# Same example as in nplot
library(igraph)
library(netplot)
set.seed(1)
x <- sample_smallworld(1, 200, 5, 0.03)

nplot_base(x) # ala netplot (using base)
}
\seealso{
\link{nplot}
}
