% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolic.index.R
\name{hyperbolic_index}
\alias{hyperbolic_index}
\title{Hyperbolic (centrality) index}
\usage{
hyperbolic_index(g, type = "odd")
}
\arguments{
\item{g}{igraph object.}

\item{type}{string. 'even' if only even length walks should be considered. 'odd' (Default)
if only odd length walks should be used.}
}
\value{
A vector containing centrality scores.
}
\description{
The hyperbolic index is an index that considers all closed
walks of even or odd length on induced neighborhoods of a vertex.
}
\details{
The hyperbolic index is an illustrative index that should
not be used for any serious analysis. Its purpose is to show that with enough mathematical
trickery, any desired result can be obtained when centrality indices are used.
}
\examples{

library(igraph)

g <- graph.empty(n=11,directed = FALSE)
g <- add_edges(g,c(1,11,2,4,3,5,3,11,4,8,5,9,5,11,6,7,6,8,
                   6,10,6,11,7,9,7,10,7,11,8,9,8,10,9,10))
hyperbolic_index(g,type = "odd")
hyperbolic_index(g,type = "even")
}
\author{
David Schoch
}
