% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-auth.R
\name{ns_auth_token}
\alias{ns_auth_token}
\title{Retrieve access token}
\usage{
ns_auth_token(
  client_id = Sys.getenv("NETTSKJEMA_CLIENT_ID"),
  client_secret = Sys.getenv("NETTSKJEMA_CLIENT_SECRET"),
  cache = TRUE,
  cache_path = fs::path_home(".nettskjema_token.rds")
)
}
\arguments{
\item{client_id}{Character. Default assumes
this is stored in .Renviron as "ns_CLIENT_ID"}

\item{client_secret}{Character. Default assumes
this is stored in .Renviron as "ns_CLIENT_SECRET"}

\item{cache}{Logical. Should the token be cached?}

\item{cache_path}{Character. File path to where
the token should be stored. Defaults to user
home directory}
}
\description{
After creating a client in Nettskjema,
this function will retrieve the access
token needed for the remaining processes
in the package. Automatically caches the
token for more efficient API usage.
}
