% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{network.dyadcount}
\alias{network.dyadcount}
\alias{network.dyadcount.network}
\title{Return the Number of (Possibly Directed) Dyads in a Network Object}
\usage{
\method{network.dyadcount}{network}(x, na.omit = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{network}}

\item{na.omit}{logical; omit edges with \code{na==TRUE} from the count?}

\item{\dots}{possible additional arguments, used by other implementations}
}
\value{
The number of dyads in the network
}
\description{
\code{network.dyadcount} returns the number of possible dyads within a
\code{network}, removing those flagged as missing if desired.  If the
network is directed, directed dyads are counted accordingly.
}
\details{
The return value \code{network.dyadcount} is equal to the number of dyads,
minus the number of \code{NULL} edges (and missing edges, if
\code{na.omit==TRUE}).  If \code{x} is directed, the number of directed
dyads is returned. If the network allows loops, the number of possible
entries on the diagnonal is added.  Allthough the function does not give an
error on multiplex networks or hypergraphs, the results probably don't make
sense.
}
\examples{

#Create a directed network with three edges
m<-matrix(0,3,3)
m[1,2]<-1; m[2,3]<-1; m[3,1]<-1
g<-network(m)
network.dyadcount(g)==6                 #Verify the directed dyad count
g<-network(m|t(m),directed=FALSE)
network.dyadcount(g)==3                         #nC2 in undirected case

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\url{http://www.jstatsoft.org/v24/i02/}
}
\seealso{
\code{\link{get.network.attribute}},
\code{\link{network.edgecount}}, \code{\link{is.directed}}
}
\author{
Mark S. Handcock \email{handcock@stat.washington.edu}, skyebend
}
\keyword{classes}
\keyword{graphs}
