\name{simTSfmri}

\alias{simTSfmri}

\title{Simulate fMRI time series}

\description{Simulates an fMRI time series for the specified design and noise type.}

\usage{
simTSfmri(design = list(), base=0, nscan = NULL, TR = NULL, SNR=NULL, noise = c("none", "white", "temporal", "low-frequency", "physiological", "task-related", "mixture"), type = c("gaussian", "rician"), weights, verbose = TRUE, rho = 0.2, freq.low = 128, freq.heart = 1.17, freq.resp = 0.2, vee=1)
}

\arguments{
  \item{design}{List generated by \code{\link{simprepTemporal}} specifying the design. If not specified, noise time series are generated.}
  \item{base}{Baseline value of the time series.}
  \item{nscan}{Number of scans.}
  \item{TR}{Repetition time in seconds.}
  \item{SNR}{Signal-to-noise ratio of the time series.}
  \item{noise}{Type of noise (white is default).}
  \item{type}{If \code{noise==white}, \code{noise==task-related} or \code{noise==mixture}, type of system noise (gaussian is default).}
  \item{weights}{If \code{noise==mixture}, vector of weights with 5 elements to specify the fraction of the noise components.}
  \item{verbose}{Logical indicating if warnings should be returned.}
  \item{rho}{If \code{noise==temporal} or \code{noise==mixture}, value of autocorrelation coefficients. The length of the vector indicates the order of the autoregressive model.}
  \item{freq.low}{If \code{noise==low-frequency} or \code{noise==mixture}, frequency of the low-frequency drift in seconds.}
  \item{freq.heart}{If \code{noise==physiological} or \code{noise==mixture}, frequency of heart rate in Hz.}
  \item{freq.resp}{If \code{noise==physiological} or \code{noise==mixture}, frequency of respiratory rate in Hz.}
  \item{vee}{If \code{type=="rician"}, non-centrality parameter of the distribution.}
}

\value{A vector representing the fMRI time series.}

\author{M. Welvaert}

\seealso{\code{\link{simVOLfmri}}, \code{\link{simprepTemporal}}}

\examples{
design <- simprepTemporal(totaltime=200, onsets=seq(1,200,40), durations=20, effectsize=1, TR=2, hrf="double-gamma")
ts <- simTSfmri(design=design, SNR=1, noise="white")
\dontrun{plot(ts, type="l")}
\dontshow{rm(design,ts)}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ high-level }
