\name{simVOLfmri}

\alias{simVOLfmri}

\title{Simulate 3D or 4D fMRI data}

\description{Simulates a 3D or 4D fMRI dataset for the specified design and with activation in the specified regions.}

\usage{
simVOLfmri(design = list(), image = list(), base=0, dim, nscan = NULL,
	TR = NULL, SNR=NULL, noise = c("none", "white", "temporal", 
	"spatial", "low-frequency", "physiological", "task-related", 
	"mixture"), type = c("gaussian", "rician"), 
	spat = c("corr", "gaussRF", "gammaRF"), weights, verbose = TRUE, 
	rho.temp = 0.2, rho.spat = 0.75, freq.low = 128, 
	freq.heart = 1.17, freq.resp = 0.2, FWHM = 4, gamma.shape = 6, 
	gamma.rate = 1, vee=1, template)
}

\arguments{
  \item{design}{List generated by \code{\link{simprepTemporal}} specifying the design. If not specified, noise images are generated.}
  \item{image}{List generated by \code{\link{simprepSpatial}} specifying the activated regions. If not specified, noise images are generated}
  \item{base}{Baseline of the data. Should be a single number or an array with the same dimensions as in \code{dim}.}
  \item{dim}{Dimensions of the image space.}
  \item{nscan}{Number of scans for noise images.}
  \item{TR}{Repetition time for noise images.}
  \item{SNR}{Signal-to-noise ratio.}
  \item{noise}{Type of noise, default is white.}
  \item{type}{If \code{noise==white} or \code{noise==mixture}, the type of system noise (default is gaussian).}
  \item{spat}{If \code{noise==spatial} or \code{noise==mixture}, the spatial correlation structure (default is \code{corr}).}
  \item{weights}{If \code{noise==mixture}, weights vector of six elements.}
  \item{verbose}{Logical indicating if warning should be printed.}
  \item{rho.temp}{If \code{noise==temporal} or \code{noise==mixture}, value of autocorrelation coefficients. The length of the vector indicates the order of the autoregressive model.}
  \item{rho.spat}{If \code{noise==spatial} or \code{noise==mixture}, and \code{spat==corr}, value of the correlation coefficient.}
  \item{freq.low}{If \code{noise==low-frequency} or \code{noise==mixture}, frequency of the low-frequency drift in seconds.}
  \item{freq.heart}{If \code{noise==physiological} or \code{noise==mixture}, frequency of heart rate in Hz.}
  \item{freq.resp}{If \code{noise==physiological} or \code{noise==mixture}, frequency of respiratory rate in Hz.}
  \item{FWHM}{If \code{noise==spatial} or \code{noise==mixture}, and \code{spat==gaussRF} or \code{spat==gammaRF}, value of the FWHM of the Gaussian kernel.}
  \item{gamma.shape}{If \code{noise==spatial} or \code{noise==mixture}, and \code{spat==gammaRF}, value of the shape parameter of the gamma distribution.}
  \item{gamma.rate}{If \code{noise==spatial} or \code{noise==mixture}, and \code{spat==gammaRF}, value of the rate parameter of the gamma distribution.}
  \item{vee}{If \code{type==rician}, non-centrality parameter of the rician distribution.}
  \item{template}{An array representing the anatomical structure or mask with dimensions equal to dim.}
}

\value{A 3D or 4D array specifying the values for each voxel in the data.}

\author{M. Welvaert}

\seealso{\code{\link{simTSfmri}}, \code{\link{simprepTemporal}}, \code{\link{simprepSpatial}}}

\examples{
design <- simprepTemporal(totaltime=200, onsets=seq(1,200,40), 
	durations=20, TR=2, effectsize=1, hrf="double-gamma")
region <- simprepSpatial(regions=2, coord=list(c(32,15),c(57,45)), 
	radius=c(10,7), form="sphere", fading=TRUE)
out <- simVOLfmri(design=design, image=region, dim=c(64,64), 
	SNR=1, noise="none")
\dontrun{plot(out[32,15,], type="l")}
\dontrun{library(lattice)
library(gplots)
levelplot(out[,,10],scales=list(tck=0), 
	col.regions=colorpanel(50,high="white",low="black"))}
\dontshow{rm(design,region,out)}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ high-level }
