% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emptyImageDimensionsMask.R
\name{emptyImageDimensionsMask}
\alias{emptyImageDimensionsMask}
\alias{empty_dim_mask}
\title{Make Mask from Empty Image Dimensions}
\usage{
emptyImageDimensionsMask(img, ..., reorient = FALSE)

empty_dim_mask(img, ..., reorient = FALSE)
}
\arguments{
\item{img}{nifti object}

\item{...}{Arguments to be passed to \code{\link{getEmptyImageDimensions}}.}

\item{reorient}{Should image be reoriented if a filename?}
}
\value{
Object of class \code{nifti}, with binary values
}
\description{
Make a mask of an image that has all irrelevant
values
}
\note{
\code{empty_dim_mask} is a shorthand for \code{emptyImageDimensionsMask}
with all the same arguments.
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rnorm(prod(dims)), dim = dims)
arr[,,10] = 0
nim = oro.nifti::nifti(arr)
out = emptyImageDimensionsMask(nim)
out_arr = emptyImageDimensionsMask(arr)
testthat::expect_equal(out_arr, array(out, dim = dim(out)))
out_arr = empty_dim_mask(arr)
}
\seealso{
\code{\link{getEmptyImageDimensions}}
}
