% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{preprocess_patients}
\alias{preprocess_patients}
\title{Preprocess MRI scans for multiple patients}
\usage{
preprocess_patients(patients.folder, clinical.covariates)
}
\arguments{
\item{patients.folder}{general folder containing sub-folders per patient with raw MRI images.}

\item{clinical.covariates}{data.frame of covariates associated to the MRI scans. Number of rows should be equal to the number of images.}
}
\value{
paths of preprocessed MRI scans. MRI preprocessed images are stored in the patient's folder.
}
\description{
This function preprocesses raw T1-weighted, T2-weighted and/or FLAIR MRI scans and generates a brain segmentation MRI scans using the FAST algorithm.
The preprocessing steps comprise imhomogeneity correction 'N4', linear coregistration of T2-weighted and/or FLAIR to the T1-weighted, registration of all available modalities to the MNI152 template with an isotropic voxel size of 1mm^3
using the 'SyN' transformation, skull stripping, and RAVEL intensity normalization.
}
\examples{

\dontrun{
# Get general folder
folder <- system.file("extdata", package = "neurodata")
# Get covariates
covariates <- system.file("covariates.txt", package = "neurodata")
# Read covariates information
clinical_info <- read.csv(file = covariates, sep = ';')
# Preprocess MRI scans: 'N4' inhomogeneity correction,
# 'SyN' non-linear transformation to MNI152 atlas template

# Brain extraction, Spatial informed MRI scan , a.k.a., brain segmentation
# and RAVEL intensity normalization only for T1-w images.
paths_preprocess_patients <- preprocess_patients(folder, clinical_info)
# Outputs paths of the preprocessed MRI scans per patient
# and applied preprocessing.
paths_preprocess_patients$patient02
}

}
\references{
Nicholas J. Tustison, Brian B. Avants, Philip A. Cook, Yuanjie Zheng, Alexander Egan, Paul A. Yushkevich, and James C. Gee. N4ITK: Improved N3 Bias Correction. IEEE Trans Med Imaging, 29:1310–1320, 2010.

B. B. Avants, C. L. Epstein, M Grossman, J. C. Gee Symmetric diffeomorphic image registration with cross-correlation: evaluating automated labeling of elderly and neurodegenerative brain. Medical Image Analysis, 12:1310–1320, 2008.

Evans, A.C., Fox, P.T., Lancaster, J., Zilles, K., Woods, R., Paus, T., Simpson, G., Pike, B., Holmes, C., Collins, D.L., Thompson, P., MacDonald, D., Iacoboni, et al. A probabilistic atlas and reference system for the human brain: International Consortium for Brain Mapping (ICBM). Philos. Trans. R. Soc. London B Biol, 356:1293-1322, 2001.

Yongyue Zhang, J. Michael Brady, Stephen Smith Hidden Markov random field model for segmentation of brain MR image. Medical Imaging 2000: Image Processing, 2000.

Jean-Philippe Fortin, Elizabeth M Sweeney, John Muschelli, Ciprian M Crainiceanu, Russell T Shinohara, Alzheimer’s Disease Neuroimaging Initiative, et al. Removing inter-subject technical variability in magnetic resonance imaging studies. NeuroImage, 132:198–212, 2016.
}
\author{
David Payares
}
