% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gld.R
\name{gld}
\alias{gld}
\alias{dgld}
\alias{pgld}
\alias{qgld}
\alias{rgld}
\title{The gamma-Lomax distribution}
\usage{
dgld(x, a, alpha, beta = 1, log = FALSE)

pgld(q, a, alpha, beta = 1, lower.tail = TRUE, log.p = FALSE)

qgld(p, a, alpha, beta = 1, lower.tail = TRUE)

rgld(n, a, alpha, beta = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a, alpha}{are shape parameters.}

\item{beta}{a scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dgld} gives the density, \code{pgld} gives the distribution
function, \code{qgld} gives the quantile function and \code{rgld} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the gamma-Lomax distribution with parameters \code{shapes} and \code{scale}.
}
\details{
The gamma-Lomax distribution \code{shape} parameters are
\eqn{a},\eqn{\alpha} and \code{scale} parameter is \eqn{\beta}, has density
given by
\deqn{f\left( x\right) =\frac{\alpha \beta ^{\alpha }}
{\Gamma \left( a\right)\left( \beta +x\right) ^{\alpha +1}}\left\{ -\alpha
\log \left( \frac{\beta }{\beta +x}\right) \right\} ^{a-1},}
where
\deqn{x>0,~a,\alpha ,\beta >0.}
}
\examples{
library(new.dist)
dgld(1, a=2, alpha=3, beta=4)
pgld(1,a=2,alpha=3,beta=4)
qgld(.8,a=2,alpha=3,beta=4)
rgld(10,a=2,alpha=3,beta=4)
}
\references{
Cordeiro, G. M., Ortega, E. M. ve Popović, B. V., 2015,
\emph{The gamma-Lomax distribution}, Journal of statistical computation and
simulation, 85 (2), 305-319.

Ristić, M. M., & Balakrishnan, N. (2012), \emph{The gamma-exponentiated}
\emph{exponential distribution. Journal of statistical computation and simulation}
, 82(8), 1191-1206.
}
