% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel.R
\name{textmodel_newsmap}
\alias{textmodel_newsmap}
\title{Semi-supervised Bayesian multinomial model for geographical document
classification}
\usage{
textmodel_newsmap(
  x,
  y,
  label = c("all", "max"),
  smooth = 1,
  drop_label = TRUE,
  verbose = quanteda_options("verbose"),
  ...
)
}
\arguments{
\item{x}{a dfm or fcm created by \code{\link[quanteda:dfm]{quanteda::dfm()}}}

\item{y}{a dfm or a sparse matrix that record class membership of the
documents. It can be created applying \code{\link[quanteda:dfm_lookup]{quanteda::dfm_lookup()}} to \code{x}.}

\item{label}{if "max", uses only labels for the maximum value in each row of
\code{y}.}

\item{smooth}{a value added to the frequency of words to smooth likelihood
ratios.}

\item{drop_label}{if \code{TRUE}, drops empty columns of \code{y} and ignore their
labels.}

\item{verbose}{if \code{TRUE}, shows progress of training.}

\item{...}{additional arguments passed to internal functions.}
}
\description{
Train a Newsmap model to predict geographical focus of documents with labels
given by a dictionary.
}
\details{
Newsmap learns association between words and classes based on the
labels in \code{y}. Therefore, rows in \code{x} and \code{y} must correspond; columns in
\code{y} must be class labels.
}
\examples{
require(quanteda)
text_en <- c(text1 = "This is an article about Ireland.",
             text2 = "The South Korean prime minister was re-elected.")

toks_en <- tokens(text_en)
label_toks_en <- tokens_lookup(toks_en, data_dictionary_newsmap_en, levels = 3)
label_dfm_en <- dfm(label_toks_en)

feat_dfm_en <- dfm(toks_en, tolower = FALSE)

model_en <- textmodel_newsmap(feat_dfm_en, label_dfm_en)
predict(model_en)

}
\references{
Kohei Watanabe. 2018. "\href{https://www.tandfonline.com/eprint/dDeyUTBrhxBSSkHPn5uB/full}{Newsmap: semi-supervised approach to geographical news classification.}"
\emph{Digital Journalism} 6(3): 294-309.
}
