% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{zero}
\alias{zero}
\alias{replace_zero,CompositionMatrix-method}
\title{Zero-Replacement}
\usage{
\S4method{replace_zero}{CompositionMatrix}(x, value, delta = 2/3)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{value}{A \code{\link{numeric}} vector giving the detection limits of each part
(in \eqn{(0,1)}).}

\item{delta}{A \code{\link{numeric}} vector specifying the fraction of the detection
limit to be used in replacement.}
}
\value{
An \code{\linkS4class{CompositionMatrix}} object, where all zero values have been
replaced.
}
\description{
Multiplicative replacement of zeros.
}
\examples{
## Data from Martín-Fernández et al. 2003
X <- data.frame(
  X1 = c(0.0000, 0.1304, 0.1963),
  X2 = c(0.1250, 0.3151, NA),
  X3 = c(0.1237, NA, NA),
  X4 = c(0.7253, 0.2002, 0.0819),
  X5 = c(0.0260, 0.3543, 0.0114)
)

## Coerce to a compositional matrix
Y <- as_composition(X)

## Replace zeros
Z <- replace_zero(Y, value = 0.02, delta = 2/3)
Z
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.

Martín-Fernández, J. A., Barceló-Vidal, C. & Pawlowsky-Glahn, V. (2003).
Dealing with Zeros and Missing Values in Compositional Data Sets Using
Nonparametric Imputation. \emph{Mathematical Geology}, 35(3): 253-278.
\doi{10.1023/A:1023866030544}.
}
\seealso{
Other imputation methods: 
\code{\link{missing}},
\code{\link{policy}}
}
\author{
N. Frerebeau
}
\concept{imputation methods}
