% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{samples}
\alias{samples}
\alias{any_replicated}
\alias{any_replicated-method}
\alias{is_replicated}
\alias{is_replicated-method}
\alias{get_samples}
\alias{get_samples-method}
\alias{set_samples<-}
\alias{set_samples-method}
\alias{is_replicated,CompositionMatrix-method}
\alias{is_replicated,LogRatio-method}
\alias{is_replicated,OutlierIndex-method}
\alias{any_replicated,CompositionMatrix-method}
\alias{any_replicated,LogRatio-method}
\alias{any_replicated,OutlierIndex-method}
\alias{get_samples,CompositionMatrix-method}
\alias{get_samples,LogRatio-method}
\alias{get_samples,OutlierIndex-method}
\alias{set_samples<-,CompositionMatrix-method}
\alias{set_samples,CompositionMatrix-method}
\title{Working With Samples}
\usage{
any_replicated(x)

is_replicated(x)

get_samples(x)

set_samples(x) <- value

\S4method{is_replicated}{CompositionMatrix}(x)

\S4method{is_replicated}{LogRatio}(x)

\S4method{is_replicated}{OutlierIndex}(x)

\S4method{any_replicated}{CompositionMatrix}(x)

\S4method{any_replicated}{LogRatio}(x)

\S4method{any_replicated}{OutlierIndex}(x)

\S4method{get_samples}{CompositionMatrix}(x)

\S4method{get_samples}{LogRatio}(x)

\S4method{get_samples}{OutlierIndex}(x)

\S4method{set_samples}{CompositionMatrix}(x) <- value
}
\arguments{
\item{x}{An object from which to get or set \code{samples}.}

\item{value}{A possible value for the \code{samples} of \code{x}.}
}
\value{
\itemize{
\item \code{set_samples()} returns an object of the same sort as \code{x} with the new
sample names assigned.
\item \code{get_samples()} returns a \code{\link{character}} vector giving the sample names of \code{x}.
\item \code{any_replicated()} returns a \code{\link{logical}} scalar specifying whether or not
\code{x} has replicated observations.
\item \code{is_replicated()} returns a \code{\link{logical}} vector specifying whether or not
an observation is a replicate.
}
}
\description{
Retrieves or defines the sample names.
}
\details{
In some situations, measurements may have been repeated (e.g. multiple
chemical analyses on the same sample). The presence of repeated
measurements can be specified by giving several observations the same
sample name.

See \code{vignette("nexus")}.
}
\seealso{
Other mutators: 
\code{\link{groups}},
\code{\link{identifiers}},
\code{\link{split}()},
\code{\link{subset}()},
\code{\link{totals}}
}
\author{
N. Frerebeau
}
\concept{mutators}
