% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{OutlierIndex-class}
\alias{OutlierIndex-class}
\alias{.OutlierIndex}
\title{Outliers}
\description{
An S4 class to store the result of outlier detection.
}
\section{Slots}{

\describe{
\item{\code{samples}}{A \code{\link{character}} vector to store the sample identifiers.}

\item{\code{groups}}{A \code{\link{factor}} vector to store the group names.}

\item{\code{standard}}{A \code{\link{numeric}} matrix giving the standard squared Mahalanobis
distances.}

\item{\code{robust}}{A \code{\link{numeric}} matrix giving the robust squared Mahalanobis
distances.}

\item{\code{limit}}{A \code{\link{numeric}} value giving the cut-off value used for outliers
detection (quantile of the Chi-squared distribution).}

\item{\code{dof}}{A (non-negative) \code{\link{numeric}} value giving the degrees of freedom.}
}}

\section{Coerce}{

In the code snippets below, \code{x} is an \code{OutlierIndex} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{LogRatio-class}},
\code{\link{LogicalMatrix-class}},
\code{\link{NumericMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
