% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_game_stats.R
\name{calculate_player_stats}
\alias{calculate_player_stats}
\title{Get Official Game Stats}
\usage{
calculate_player_stats(pbp, weekly = FALSE)
}
\arguments{
\item{pbp}{A Data frame of NFL play-by-play data typically loaded with
\code{\link[=load_pbp]{load_pbp()}} or \code{\link[=build_nflfastR_pbp]{build_nflfastR_pbp()}}. If the data doesn't include the variable
\code{qb_epa}, the function \code{add_qb_epa()} will be called to add it.}

\item{weekly}{If \code{TRUE}, returns week-by-week stats, otherwise, stats
for the entire Data frame.}
}
\value{
A data frame including the following columns (all ID columns are
decoded to the gsis ID format):
\describe{
\item{player_id}{ID of the player. Use this to join to other sources.}
\item{player_name}{Name of the player}
\item{games}{The number of games where the player recorded passing, rushing or receiving stats.}
\item{recent_team}{Most recent team player appears in \code{pbp} with.}
\item{season}{Season if \code{weekly} is \code{TRUE}}
\item{week}{Week if \code{weekly} is \code{TRUE}}
\item{completions}{The number of completed passes.}
\item{attempts}{The number of pass attempts as defined by the NFL.}
\item{passing_yards}{Yards gained on pass plays.}
\item{passing_tds}{The number of passing touchdowns.}
\item{interceptions}{The number of interceptions thrown.}
\item{sacks}{Number of times sacked.}
\item{sack_fumbles_lost}{The number of sacks with a lost fumble.}
\item{passing_air_yards}{Passing air yards (includes incomplete passes).}
\item{passing_yards_after_catch}{Yards after the catch gained on plays in
which player was the passer (this is an unofficial stat and may differ slightly
between different sources).}
\item{passing_first_downs}{First downs on pass attempts.}
\item{passing_epa}{Total expected points added on pass attempts and sacks.
NOTE: this uses the variable \code{qb_epa}, which gives QB credit for EPA for up
to the point where a receiver lost a fumble after a completed catch and makes
EPA work more like passing yards on plays with fumbles.}
\item{passing_2pt_conversions}{Two-point conversion passes.}
\item{dakota}{Adjusted EPA + CPOE composite based on coefficients which best predict adjusted EPA/play in the following year.}
\item{carries}{The number of official rush attempts (incl. scrambles and kneel downs).
Rushes after a lateral reception don't count as carry.}
\item{rushing_yards}{Yards gained when rushing with the ball (incl. scrambles and kneel downs).
Also includes yards gained after obtaining a lateral on a play that started
with a rushing attempt.}
\item{rushing_tds}{The number of rushing touchdowns (incl. scrambles).
Also includes touchdowns after obtaining a lateral on a play that started
with a rushing attempt.}
\item{rushing_fumbles_lost}{The number of rushes with a lost fumble.}
\item{rushing_first_downs}{First downs on rush attempts (incl. scrambles).}
\item{rushing_epa}{Expected points added on rush attempts (incl. scrambles and kneel downs).}
\item{rushing_2pt_conversions}{Two-point conversion rushes}
\item{receptions}{The number of pass receptions. Lateral receptions officially
don't count as reception.}
\item{targets}{The number of pass plays where the player was the targeted receiver.}
\item{receiving_yards}{Yards gained after a pass reception. Includes yards
gained after receiving a lateral on a play that started as a pass play.}
\item{receiving_tds}{The number of touchdowns following a pass reception.
Also includes touchdowns after receiving a lateral on a play that started
as a pass play.}
\item{receiving_air_yards}{Receiving air yards (incl. incomplete passes).}
\item{receiving_yards_after_catch}{Yards after the catch gained on plays in
which player was receiver (this is an unofficial stat and may differ slightly
between different sources).}
\item{receiving_fumbles_lost}{The number of fumbles after a pass reception.}
\item{receiving_2pt_conversions}{Two-point conversion receptions}
\item{fantasy_points}{Standard fantasy points.}
\item{fantasy_points_ppr}{PPR fantasy points.}
}
}
\description{
Build columns that aggregate official passing, rushing, and receiving stats
either at the game level or at the level of the entire data frame passed.
}
\examples{
\donttest{
pbp <- nflfastR::load_pbp(2020)

weekly <- calculate_player_stats(pbp, weekly = TRUE)
dplyr::glimpse(weekly)

overall <- calculate_player_stats(pbp, weekly = FALSE)
dplyr::glimpse(overall)
}
}
\seealso{
The function \code{\link[=load_player_stats]{load_player_stats()}} and the corresponding examples
on \href{https://www.nflfastr.com/articles/nflfastR.html#example-11-replicating-official-stats}{the nflfastR website}
}
