% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_game_stats_def.R
\name{calculate_player_stats_def}
\alias{calculate_player_stats_def}
\title{Get Official Game Stats on Defense}
\usage{
calculate_player_stats_def(pbp, weekly = FALSE)
}
\arguments{
\item{pbp}{A Data frame of NFL play-by-play data typically loaded with
\code{\link[=load_pbp]{load_pbp()}} or \code{\link[=build_nflfastR_pbp]{build_nflfastR_pbp()}}. If the data doesn't include the variable
\code{qb_epa}, the function \code{add_qb_epa()} will be called to add it.}

\item{weekly}{If \code{TRUE}, returns week-by-week stats, otherwise, stats
for the entire Data frame.}
}
\value{
A data frame of defensive player stats. See dictionary (# TODO)
}
\description{
Build columns that aggregate official defense stats
either at the game level or at the level of the entire data frame passed.
}
\examples{
\donttest{
try({# to avoid CRAN test problems
  pbp <- nflfastR::load_pbp(2020)

  weekly <- calculate_player_stats_def(pbp, weekly = TRUE)
  dplyr::glimpse(weekly)

  overall <- calculate_player_stats_def(pbp, weekly = FALSE)
  dplyr::glimpse(overall)
})
}

}
\seealso{
The function \code{\link[=load_player_stats]{load_player_stats()}} and the corresponding examples
on \href{https://www.nflfastr.com/articles/nflfastR.html#example-11-replicating-official-stats}{the nflfastR website}
}
