% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_name_cleaning.R
\name{clean_team_abbrs}
\alias{clean_team_abbrs}
\title{Standardize NFL Team Abbreviations}
\usage{
clean_team_abbrs(abbr, current_location = TRUE, keep_non_matches = TRUE)
}
\arguments{
\item{abbr}{a character vector of abbreviations}

\item{current_location}{If \code{TRUE} (the default), the abbreviation of the most
recent team location will be used.}

\item{keep_non_matches}{If \code{TRUE} (the default) an element of \code{abbr} that can't
be matched to any of the internal mapping vectors will be kept as is. Otherwise
it will be replaced with \code{NA}.}
}
\value{
A character vector with the length of \code{abbr} and cleaned team abbreviations
if they are included in \code{\link{team_abbr_mapping}} or \code{\link{team_abbr_mapping_norelocate}}
(depending on the value of \code{current_location}). Non matches may be replaced
with \code{NA} (depending on the value of \code{keep_non_matches}).
}
\description{
This function standardizes NFL team abbreviations to nflverse defaults.
This helps for joins and plotting, especially with the new nflplotR package!
}
\examples{
x <- c("PIE", "LAR", "PIT", "CRD", "OAK", "SL")
# use current location and keep non matches
clean_team_abbrs(x)

# keep old location and replace non matches
clean_team_abbrs(x, current_location = FALSE, keep_non_matches = FALSE)
}
