% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_download_nflverse.R
\name{nflverse_download}
\alias{nflverse_download}
\title{Bulk download utilities via piggyback}
\usage{
nflverse_download(
  ...,
  folder_path = getOption("nflreadr.download_path", default = "."),
  file_type = getOption("nflreadr.prefer", default = "rds"),
  use_hive = file_type \%in\% c("parquet", "csv")
)
}
\arguments{
\item{...}{releases to download, provided in either unquoted or character format
(i.e. pbp or "pbp" are both fine). Available release names can be listed with
\code{\link[=nflverse_releases]{nflverse_releases()}}}

\item{folder_path}{a folder in which subfolders will be created for each release -
defaults to path specified in \code{options(nflreadr.download_path)} or "." (the current working directory)}

\item{file_type}{one of \code{c("rds","parquet", "csv", "qs")} -
defaults to file type specified in \code{options(nflreadr.prefer)} or "rds"}

\item{use_hive}{whether to create hive-style partition folders for each season, e.g. \code{"~/pbp/.season=2021/pbp.csv"}}
}
\description{
This function downloads or updates data from the nflverse-data repository releases,
creating subfolders that match the release structure.
}
\examples{
{
\donttest{
try({
  ## could also set options like
  # options(nflreadr.download_path = tempdir(), nflreadr.prefer = "parquet")

  nflverse_download(combine, contracts, folder_path = tempdir(), file_type = "parquet")

  list.files(tempdir(),pattern = ".parquet$") # check that files were downloaded!
})
}
}
}
