% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{parse_args}
\alias{parse_args}
\title{Parse command line options (optparse).}
\usage{
parse_args(...)
}
\arguments{
\item{...}{Parameters pass to \code{\link[optparse]{parse_args}}}
}
\description{
Parse command line options (optparse).
}
\examples{

# example from vignette
option_list <- list(
  make_option(c('-v', '--verbose'), action='store_true', default=TRUE,
      help='Print extra output [default]'),
  make_option(c('-q', '--quietly'), action='store_false',
      dest='verbose', help='Print little output'),
  make_option(c('-c', '--count'), type='integer', default=5,
      help='Number of random normals to generate [default \%default]',
      metavar='number'),
  make_option('--generator', default='rnorm',
      help = 'Function to generate random deviates [default \\'\%default\\']'),
  make_option('--mean', default=0,
      help='Mean if generator == \\'rnorm\\' [default \%default]'),
  make_option('--sd', default=1, metavar='standard deviation',
      help='Standard deviation if generator == \\'rnorm\\' [default \%default]')
  )
parse_args(opt_parser(option_list = option_list), args = c('--sd=3', '--quietly'))

}
