% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{browseNHANES}
\alias{browseNHANES}
\title{Open a browser to NHANES.}
\usage{
browseNHANES(year = NULL, nh_surveygroup = NULL, nh_table = NULL,
  dxa = FALSE)
}
\arguments{
\item{year}{The year in yyyy format where 1999 <= yyyy <= 2014.}

\item{nh_surveygroup}{The type of survey (DEMOGRAPHICS, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{nh_table}{The name of an NHANES table.}

\item{dxa}{If TRUE then browse to the DXA page.}
}
\description{
The browser may be directed to a specific year, survey, or table.
}
\details{
browseNHANES will open a web browser to the specified NHANES site.
}
\examples{
\donttest{browseNHANES()}                     Defaults to the main data sets page
\donttest{browseNHANES(2005)}                 The main page for the specified survey year
\donttest{browseNHANES(2009, 'EXAM')}         Page for the specified year and survey group
\donttest{browseNHANES(nh_table = 'VIX_D')}   Page for a specific table
\donttest{browseNHANES(dxa=T)}                DXA main page
}

