% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_search.R
\name{nhanesSearch}
\alias{nhanesSearch}
\title{Perform a search over the comprehensive NHANES variable list.}
\usage{
nhanesSearch(
  search_terms = NULL,
  exclude_terms = NULL,
  data_group = NULL,
  ignore.case = FALSE,
  ystart = NULL,
  ystop = NULL,
  includerdc = FALSE,
  nchar = 128,
  namesonly = FALSE
)
}
\arguments{
\item{search_terms}{List of terms or keywords.}

\item{exclude_terms}{List of exclusive terms or keywords.}

\item{data_group}{Which data groups (e.g. DIET, EXAM, LAB) to search. Default is to search all groups.}

\item{ignore.case}{Ignore case if TRUE. (Default=FALSE).}

\item{ystart}{Four digit year of first survey included in search, where ystart >= 1999.}

\item{ystop}{Four digit year of final survey included in search, where ystop >= ystart.}

\item{includerdc}{If TRUE then RDC only tables are included in list (default=FALSE).}

\item{nchar}{Truncates the variable description to a max length of nchar.}

\item{namesonly}{If TRUE then only the table names are returned (default=FALSE).}
}
\value{
Returns a data frame that describes variables that matched the search terms. If namesonly=TRUE,
then a character vector of table names that contain matched variables is returned.
}
\description{
The descriptions in the master variable list will be filtered by the
provided search terms to retrieve a list of relevant variables. 
The search can be restricted to specific survey years by specifying ystart and/or ystop.
}
\details{
nhanesSearch is useful to obtain a comprehensive list of relevant tables.
Search terms will be matched against the variable descriptions in the NHANES Comprehensive
Variable Lists.
Matching variables must have at least one of the search_terms and not have any exclude_terms.
The search may be restricted to specific surveys using ystart and ystop.
If no arguments are given, then nhanesSearch returns the complete variable list.
}
\examples{
 \donttest{nhanesSearch("bladder", ystart=2001, ystop=2008, nchar=50)}
 \donttest{nhanesSearch("urin", exclude_terms="During", ystart=2009)}
 \donttest{nhanesSearch(c("urine", "urinary"), ignore.case=TRUE, ystop=2006, namesonly=TRUE)}
}
