% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_geometry.R
\name{get_node}
\alias{get_node}
\title{Get Flowline Node}
\usage{
get_node(x, position = "end")
}
\arguments{
\item{x}{sf data.frame with one or more flowlines}

\item{position}{character either "start" or "end"}
}
\value{
sf data.frame containing requested nodes
}
\description{
Given one or more flowlines, returns
  a particular node from the flowline.
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

fline <- sf::read_sf(sample_data, "NHDFlowline_Network")

start <- get_node(fline, "start")
end <- get_node(fline, "end")

plot(sf::st_zm(fline$geom),
     lwd = fline$StreamOrde, col = "blue")
plot(sf::st_geometry(start), add = TRUE)

plot(sf::st_zm(fline$geom),
     lwd = fline$StreamOrde, col = "blue")
plot(sf::st_geometry(end), add = TRUE)

}
