% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEV.R
\name{GEV}
\alias{GEV}
\alias{dGEV}
\alias{pGEV}
\alias{qGEV}
\alias{rGEV}
\title{Density, Distribution Function, Quantile Function and
Random Generation for the Generalized Extreme Value (GEV)
Distribution}
\usage{
dGEV(
  x,
  loc = 0,
  scale = 1,
  shape = 0,
  log = FALSE,
  deriv = FALSE,
  hessian = FALSE
)

pGEV(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE, deriv = FALSE)

qGEV(
  p,
  loc = 0,
  scale = 1,
  shape = 0,
  lower.tail = TRUE,
  deriv = FALSE,
  hessian = FALSE
)

rGEV(n, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{loc}{Location parameter. Numeric vector with suitable
length, see \bold{Details}.}

\item{scale}{Scale parameter. Numeric vector with suitable length,
see \bold{Details}.}

\item{shape}{Shape parameter. Numeric vector with suitable length,
see \bold{Details}.}

\item{log}{Logical; if \code{TRUE}, densities \code{p} are
returned as \code{log(p)}.}

\item{deriv}{Logical. If \code{TRUE}, the gradient of each
computed value w.r.t. the parameter vector is computed, and
returned as a \code{"gradient"} attribute of the result. This is a
numeric array with dimension \code{c(n, 3)} where \code{n} is the
length of the first argument, i.e. \code{x}, \code{p} or \code{q}
depending on the function.}

\item{hessian}{Logical. If \code{TRUE}, the Hessian of each
computed value w.r.t. the parameter vector is computed, and
returned as a \code{"hessian"} attribute of the result. This is a
numeric array with dimension \code{c(n, 3, 3)} where \code{n} is
the length of the first argument, i.e. \code{x}, \code{p} or
depending on the function.}

\item{lower.tail}{Logical; if \code{TRUE} (default), probabilities
are \eqn{\textrm{Pr}[X \leq x]}{Pr[X <= x]}, otherwise,
\eqn{\textrm{Pr}[X>x]}{Pr[X > x]}.}

\item{p}{Vector of probabilities.}

\item{n}{Sample size.}
}
\value{
A numeric vector with length \code{n} as described in the
    \bold{Details} section. When \code{deriv} is \code{TRUE}, the
    returned value has an attribute named \code{"gradient"} which
    is a matrix with \eqn{n} lines and \eqn{3} columns containing
    the derivatives. A row contains the partial derivatives of the
    corresponding element w.r.t. the three parameters \code{loc}
    \code{scale} and \code{shape} in that order.
}
\description{
Density, distribution function, quantile function and
    random generation for the Generalized Extreme Value (GEV)
    distribution with parameters \code{loc}, \code{scale} and
    \code{shape}.
    The distribution function \eqn{F(x) = \textrm{Pr}[X \leq x]}{F(x)= Pr[X <= x]}
    is given by 
    \deqn{F(x) = \exp\left\{-[1 + \xi z]^{-1/\xi}\right\}}{F(x) = exp(-(1 + xi * z))}
    when \eqn{\xi \neq 0}{xi != 0} and \eqn{1 + \xi z > 0}{1 + xi * z > 0}, and by 
    \deqn{F(x) = \exp\left\{-e^{-z}\right\}}{F(x) = exp(-exp(-z))}
    for \eqn{\xi =0}{xi == 0} where \eqn{z := (x - \mu) / \sigma} in both cases.
}
\details{
Each of the probability function normally requires two
    formulas: one for the non-zero shape case \eqn{\xi \neq 0}{\xi
    != 0} and one for the zero-shape case \eqn{\xi = 0}. However
    the non-zero shape formulas lead to numerical instabilities
    near \eqn{\xi = 0}, especially for the derivatives
    w.r.t. \eqn{\xi}. This can create problem in optimization
    tasks. To avoid this, a Taylor expansion w.r.t. \eqn{\xi} is
    used for \eqn{|\xi| < \epsilon} for a small positive
    \eqn{\epsilon}.  The expansion has order \eqn{2} for the
    functions (log-density, distribution and quantile), order
    \eqn{1} for their first-order derivatives and order \eqn{0}
    for the second-order derivatives.

    For the \code{d}, \code{p} and \code{q} functions, the GEV
    parameter arguments \code{loc}, \code{scale} and \code{shape}
    are recycled in the same fashion as the classical R
    distribution functions in the \pkg{stats} package, see e.g.,
    \code{\link[stats]{Normal}}, \code{\link[stats]{GammaDist}}, ...
    Let \code{n} be the maximum length of the four arguments:
    \code{x} \code{q} or \code{p} and the GEV parameter arguments,
    then the four provided vectors are recycled in order to have
    length \code{n}. The returned vector has length \code{n} and
    the attributes \code{"gradient"} and \code{"hessian"}, when
    computed, are arrays wich dimension: \code{c(1, 3)} and
    \code{c(1, 3, 3)}.
}
\examples{
ti <- 1:10; names(ti) <- 2000 + ti
mu <- 1.0 + 0.1 * ti
## simulate 40 paths
y <- rGEV(n = 40, loc = mu, scale = 1, shape = 0.05)
matplot(ti, y, type = "l", col = "gray")
lines(ti, apply(y, 1, mean))
}
