% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpAaCNOd/file312c41c44234
\name{nimble-R-functions}
\alias{c}
\alias{diag}
\alias{length}
\alias{nimC}
\alias{nimRep}
\alias{nimSeq}
\alias{nimble-R-functions}
\alias{rep}
\alias{seq}
\alias{which}
\title{NIMBLE language functions for R-like vector construction}
\usage{
nimC(...)

nimRep(x, ...)

nimSeq(from, to, by, length.out)
}
\arguments{
\item{...}{values to be concatenated.}

\item{x}{vector of values to be replicated (\code{rep}) or logical array or vector (\code{which}) or object whose length is wanted (\code{length}) or input value (\code{diag}).}

\item{from}{starting value of sequence.}

\item{to}{end value of sequence.}

\item{by}{increment of the sequence.}

\item{length.out}{desired length of the sequence.}
}
\description{
These functions can be used in nimbleFunctions and compiled using \code{compileNimble}.
}
\details{
For \code{c}, \code{rep}, \code{seq}, these functions are NIMBLE's version of similar R functions, e.g., \code{nimRep} for \code{rep}.   In a \code{nimbleFunction}, either the R name (e.g., \code{rep}) or the NIMBLE name (e.g., \code{nimRep}) can be used.  If the R name is used, it will be converted to the NIMBLE name. For \code{which}, \code{length}, \code{diag}, simply use the standard name without \code{"nim"}. These functions largely mimic (see exceptions below) the behavior of their R counterparts, but they can be compiled in a \code{nimbleFunction} using \code{compileNimble}.

\code{nimC} is NIMBLE's version of \code{c} and behaves identically.

\code{nimRep} is NIMBLE's version of \code{rep}.  It should behave identically to \code{rep}.  There are no NIMBLE versions of \code{rep.int} or \code{rep_len}.

\code{nimSeq} is NIMBLE's version of \code{seq}.  It behaves like \code{seq} with support for \code{from}, \code{to}, \code{by} and \code{length.out} arguments.  The \code{along.with} argument is not supported.  There are no NIMBLE versions of \code{seq.int}, \code{seq_along} or \code{seq_len}, with the exception that \code{seq_along} can take a nimbleFunctionList as an argument to provide the index range of a for-loop (User Manual Ch. 13).

\code{which} behaves like the R version but without support for \code{arr.ind} or \code{useNames} arguments.

\code{diag} behaves like the R version but without support for the \code{nrow} and \code{ncol} arguments.

\code{length} behaves like the R version.
}

