% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpoisppDetection_normal.R
\name{dpoisppDetection_normal}
\alias{dpoisppDetection_normal}
\alias{rpoisppDetection_normal}
\title{Poisson point process detection model}
\usage{
dpoisppDetection_normal(
  x,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  numMaxPoints,
  numWindows,
  indicator,
  log = 0
)

rpoisppDetection_normal(
  n,
  lowerCoords,
  upperCoords,
  s,
  sd,
  baseIntensities,
  numMaxPoints,
  numWindows,
  indicator
)
}
\arguments{
\item{x}{Matrix containing the total number of detections (x[1,1]), the x- and y-coordinates (x[2:(x[1,1]+1),1:2]), 
and the corresponding detection window indices (x[2:(x[1,1]+1),3]) for a set of spatial points (detection locations).}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all detection windows. One row for each window.}

\item{s}{Vector of x- and y-coordinates of the isotropic multivariate normal distribution mean (the AC location).}

\item{sd}{Standard deviation of the isotropic multivariate normal distribution.}

\item{baseIntensities}{Vector of baseline detection intensities for all detection windows.}

\item{numMaxPoints}{Maximum number of points. This value (non-negative integer) is only used when simulating detections to constrain the maximum number of detections.}

\item{numWindows}{Number of detection windows. This value (positive integer) is used to truncate \code{lowerCoords} and \code{upperCoords} 
so that extra rows beyond \code{numWindows} are ignored.}

\item{indicator}{Binary variable (0 or 1) used for data augmentation. \code{indicator = 0} means the individual does not exist 
and thus the probability of no detection is 1.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
\code{dpoisppDetection_normal} gives the (log) probability density of the observation matrix \code{x}.
\code{rpoisppDetection_normal} gives coordinates of a set of randomly generated spatial points.
}
\description{
Density and random generation functions of the Poisson point process for detection. 
The \code{dpoisppDetection_normal} distribution is a NIMBLE custom distribution which can be used to model and simulate
Poisson observations (\emph{x}) of a single individual in continuous space over a set of detection windows defined by their upper and lower
coordinates (\emph{lowerCoords,upperCoords}). The distribution assumes that an individual’s detection intensity 
follows an isotropic multivariate normal centered on the individual's activity center (\emph{s}) with standard deviation (\emph{sd}).
}
\examples{
coordsHabitatGridCenter <- matrix(c(0.5, 3.5,
                                    1.5, 3.5,
                                    2.5, 3.5,
                                    3.5, 3.5,
                                    0.5, 2.5,
                                    1.5, 2.5,
                                    2.5, 2.5,
                                    3.5, 2.5,
                                    0.5, 1.5,
                                    1.5, 1.5,
                                    2.5, 1.5,
                                    3.5, 1.5,
                                    0.5, 0.5,
                                    1.5, 0.5,
                                    2.5, 0.5,
                                    3.5, 0.5), ncol = 2,byrow = TRUE)
colnames(coordsHabitatGridCenter) <- c("x","y")
# Create observation windows
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
colnames(lowerCoords) <- colnames(upperCoords) <- c("x","y")

# Rescale coordinates
ScaledLowerCoords <- scaleCoordsToHabitatGrid(coordsData =  lowerCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords <- scaleCoordsToHabitatGrid(coordsData =  upperCoords,
                                              coordsHabitatGridCenter = coordsHabitatGridCenter)
ScaledUpperCoords$coordsDataScaled[,2] <- ScaledUpperCoords$coordsDataScaled[,2] + 1.5
ScaledLowerCoords$coordsDataScaled[,2] <- ScaledLowerCoords$coordsDataScaled[,2] - 1.5



# Detection locations
x <- matrix(c(1.5, 2, 1.1, 1.5,0.6, 2.1, 0.5, 2, 1, 1.5), nrow = 5, byrow = TRUE)

# get the window indeces on the third dimension of x

windowIndexes <- 0
for(i in 1:nrow(x)){
  windowIndexes[i] <- getWindowIndex(curCoords = x[i,],
                                     lowerCoords = ScaledLowerCoords$coordsDataScaled,
                                     upperCoords = ScaledUpperCoords$coordsDataScaled)
}
x <- cbind(x, windowIndexes)
# get the total number of detections on x[1,1]
x <- rbind(c(length(windowIndexes),0,0) ,x )


s <- c(1, 1)
sd <- 0.1
baseIntensities <- c(1:4)
windowIndices <- c(1, 2, 2, 3, 4)
numPoints <- 5
numWindows <- 4
indicator <- 1
dpoisppDetection_normal(x, lowerCoords, upperCoords, s, sd, baseIntensities,
                        numMaxPoints = dim(x)[1] , numWindows, indicator, log = TRUE)
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
