% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nixtla_client_historic.R
\name{nixtla_client_historic}
\alias{nixtla_client_historic}
\title{Generate 'TimeGPT' forecast for the in-sample period (historical period).}
\usage{
nixtla_client_historic(
  df,
  freq = NULL,
  id_col = NULL,
  time_col = "ds",
  target_col = "y",
  level = NULL,
  finetune_steps = 0,
  finetune_loss = "default",
  clean_ex_first = TRUE
)
}
\arguments{
\item{df}{A tsibble or a data frame with time series data.}

\item{freq}{Frequency of the data.}

\item{id_col}{Column that identifies each series.}

\item{time_col}{Column that identifies each timestep.}

\item{target_col}{Column that contains the target variable.}

\item{level}{The confidence levels (0-100) for the prediction intervals.}

\item{finetune_steps}{Number of steps used to finetune 'TimeGPT' in the new data.}

\item{finetune_loss}{Loss function to use for finetuning. Options are: "default", "mae", "mse", "rmse", "mape", and "smape".}

\item{clean_ex_first}{Clean exogenous signal before making the forecasts using 'TimeGPT'.}
}
\value{
'TimeGPT''s forecast for the in-sample period.
}
\description{
Generate 'TimeGPT' forecast for the in-sample period (historical period).
}
\examples{
\dontrun{
  nixtlar::nixtla_set_api_key("YOUR_API_KEY")
  df <- nixtlar::electricity
  fcst <- nixtlar::nixtla_client_historic(df, id_col="unique_id", level=c(80,95))
}

}
