% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlive.pmma.R
\name{nlive.pmma}
\alias{nlive.pmma}
\title{Automated Estimation of the Piecewise Linear Mixed Model with Abrupt Change}
\usage{
nlive.pmma(
  dataset,
  ID,
  outcome,
  time,
  var.all = NULL,
  var.last.level = NULL,
  var.slope1 = NULL,
  var.slope2 = NULL,
  var.changepoint = NULL,
  start = NULL,
  plot.xlabel = NULL,
  plot.ylabel = NULL,
  traj.marg = FALSE,
  traj.marg.group = NULL,
  traj.marg.title = NULL,
  traj.marg.group.title = NULL,
  traj.marg.group.val = NULL
)
}
\arguments{
\item{dataset}{data frame containing the variables ID, outcome, time, var.all, and all other var. arguments.}

\item{ID}{name of the variable representing the grouping structure specified with " (e.g., "ID" representing the unique identifier of participants).}

\item{outcome}{name of the time-varying variable representing the longitudinal outcome specified with " (e.g., "outcome").}

\item{time}{name of the variable representing the timescale specified with " (e.g., "time"), which can be negative or positive.}

\item{var.all}{optional vector indicating the name of the variable(s) that the four main parameters of the model will be adjusted to (e.g. var.all=c("X1","X2")). Default to NULL.}

\item{var.last.level}{optional vector indicating the name of the variable(s) that the last level parameter of the model of interest will be adjusted to (e.g. var.last.level=c("X1","X2")). Default to NULL.}

\item{var.slope1}{optional vector indicating the name of the variable(s) that the slope1 (before changepoint) parameter of the model of interest will be adjusted to (e.g. var.slope1=c("X1","X2"). Default to NULL.}

\item{var.slope2}{optional vector indicating the name of the variable(s) that the slope2 (after changepoint) parameter of the model of interest will be adjusted to (e.g. var.slope2=c("X1","X2"). Default to NULL.}

\item{var.changepoint}{optional vector indicating the name of the variable(s) that the changepoint parameter of the model of interest will be adjusted to (e.g. var.changepoint=c("X1","X2")). Default to NULL.}

\item{start}{optional vector to override the specification of the four initial values for the main parameters - values must be included in the following order: intercept, slope before the changepoint, slope after the changepoint, changepoint. Default to NULL.}

\item{plot.xlabel}{optional text for the title of the x-axis of all plots.}

\item{plot.ylabel}{optional text for the title of the y-axis of all plots.}

\item{traj.marg}{optional logical indicating if the marginal estimated trajectory should be plotted for the most common profile of covariates, if any. Default to FALSE.}

\item{traj.marg.group}{optional name of the grouping variable listed in one of the predictor arguments to plot and contrast the estimated marginal trajectories between two specific groups, specified with " (e.g., traj.marg.group="X1"). If the variable is binary, the trajectories are contrasted between the two groups of interest. If the variable is continuous, the 10th and 90th percentile values will automatically be considered. The default value is NULL.}

\item{traj.marg.title}{optional text for the title of the marginal estimated trajectory}

\item{traj.marg.group.title}{optional text for the title of the marginal estimated trajectories contrasted between groups}

\item{traj.marg.group.val}{optional vector that can be used when \emph{traj.marg.group} receives a quantitative variable and that allows to manually specify two percentile values to be considered for contrasting the traj.marg.group. The two values must be between 0 and 1 (e.g., traj.marg.group.val=c(0.2,0.8); for percentiles 20th and 80th). Default to 10th and 90th percentiles (i.e., traj.marg.group.val=c(0.1,0.9)).}
}
\value{
An object of class SaemixObject (from the existing \emph{saemix} R package)
containing the results of the fit of the data by the PMM-abrupt. The \emph{nlive.pmma} function
automatically provides the standard saemix output, including the fixed effects estimates,
the variance of random effects, and Likelihood of the fitted model. The outputs are printed
on the terminal and the numerical and graphical outputs are stored in a directory.
}
\description{
The nlive.pmma() function allows to fit a Piecewise Linear Mixed Models with abrupt
change in the context of longitudinal Gaussian outcomes. This function was designed to
be intuitive enough to the less sophisticated users, while using recent developments such
as the stochastic approximation expectation-maximization (SAEM) algorithm for efficient
estimation. It was designed to optimize the initial values of the main parameters and help
interpretation of the output by providing different features such as annotated outputs and
graphs.
}
\details{
CAUTIONS REGARDING THE USE OF THE FUNCTION

traj.marg: if "TRUE", this argument automatically plots the estimated marginal trajectories of the longitudinal outcome
for the most common profile of covariates, if any (i.e., ref "1" for binary variables and mean values for continuous variables).
Thus, users must ensure that continuous variables are centered on the mean.
}
\examples{

#### Fitting a piecewise mixed model with abrupt change - with no covariate
\dontrun{
head(dataCog)
pmm.abrupt.fit = nlive.pmma(dataset=dataCog, ID="ID", outcome="cognition", time="time")
}
#### plot(pmm.abrupt.fit): diagnostic plots to assess the goodness-of-fit of pmm.abrupt.fit
#### psi(pmm.abrupt.fit): estimates of individual parameters


}
\references{
The Piecewise linear mixed model with abrupt and polynomial smooth change are described in van den Hout A, Muniz-Terrera G, Matthews F (2011). Smooth random change point models. Statistics in Medicine, 30(6):599-610.
The saemix R package and SAEM algorithm are described in Comets E, Lavenu A, Lavielle MM (2017). Parameter estimation in nonlinear mixed effect models using saemix, an R implementation of the SAEM algorithm. Journal of Statistical Software, 80(3):1-41.
}
\author{
Maude Wagner, Ana W. Capuano, Emmanuelle Comets

\email{maude_wagner@rush.edu}
}
