% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumericalCheck.R
\name{NumericalCheck}
\alias{NumericalCheck}
\title{The numerical predictive checks}
\usage{
NumericalCheck(orig_data,
               sim_data,
               N_xbin=NULL,
               pred.level=c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9),
               conf.level=0.95,
               X_name="TIME",
               Y_name="DV",
               MissingDV = NULL,
               Kmethod="cluster",                
               maxK=NULL,
               beta=0.2,
               lambda=0.3,
               R=4,
               C1=2.5,
               C2=7.8,...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{N_xbin}{Number of bins in X variable. If NULL, optimal number of bins are automatically calcuated using optK function.}

\item{pred.level}{Numeric vector of probabilities.}

\item{conf.level}{Confidence level of the interval.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{The maximum number of bins.}

\item{beta}{Additional parameter for automatic binning, used in optK function.}

\item{lambda}{Additional parameter for automatic binning, used in optK function.}

\item{R}{Additional parameter for automatic binning, used in optK function.}

\item{C1}{Additional parameter for automatic binning, used in optK function.}

\item{C2}{Additional parameter for automatic binning, used in optK function.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The result of numerical predictive check
}
\description{
This function calculates the numerical predictive checks for 
each prediction level.
}
\examples{
\donttest{
data(origdata)
data(simdata)
NumericalCheck(origdata,simdata)$NPC
}
}
\references{
Holford N, & Karlsson M. (2008). "A tutorial on visual predictive checks,
 abstr 1434." Annual Meeting of the Populations Approach Group in Europe. www.page-meeting.org. 2008.

Harling, Uekcert, K. 2018. VPC and NPC User Guide. ICON plc.

https://github.com/UUPharmacometrics/PsN/releases/download/4.9.0/vpc_npc_userguide.pdf.
}
