% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootVPC.R
\name{bootVPC}
\alias{bootVPC}
\title{the bootstrap visual predicrive checks.}
\usage{
bootVPC(orig_data,
        sim_data,
        B = 1000,                  
        N_xbin = NULL,
        conf.level = 0.95,
        X_name = "TIME",
        Y_name = "DV",
        subject_name = "ID",                  
        MissingDV = NULL,
        DV_point = TRUE,                  
        plot_caption = TRUE,                  
        plot_flag = TRUE,
        linesize = 0.7,
        pointsize = 0.7,
        Kmethod = "cluster",                
        maxK = NULL,
        beta = 0.2,
        lambda = 0.3,
        R = 4,                
        C1 = 2.5,
        C2 = 7.8, ...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{B}{Number of bootstrap samples.}

\item{N_xbin}{Number of bins in X variable. If NULL, optimal number of bins are automatically calcuated using optK function.}

\item{conf.level}{Confidence level of the interval.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{subject_name}{Name of subject variable in orig_data (usually "ID" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{DV_point}{Draw point (X, Y) in the plot if TRUE; omit if FALSE.}

\item{plot_caption}{Put caption with additional information if TRUE; omit if FALSE.}

\item{plot_flag}{Draw plot if TRUE; generate data for drawing plot if FALSE.}

\item{linesize}{Size of line in the plot.}

\item{pointsize}{Size of point in the plot.}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{The maximum number of bins.}

\item{beta}{Additional parameter for automatic binning, used in optK function.}

\item{lambda}{Additional parameter for automatic binning, used in optK function.}

\item{R}{Additional parameter for automatic binning, used in optK function.}

\item{C1}{Additional parameter for automatic binning, used in optK function.}

\item{C2}{Additional parameter for automatic binning, used in optK function.}

\item{...}{Arguments to be passed to methods.}
}
\value{
bootVPC plot or the values to draw bootVPC plot.
}
\description{
This function draws the visual predictive check plot with bootstrapped data.
  It compares
 the distribution of quantiles obtained from the bootstrapped data to 
 the distribution of quantiles from simulated data drawn from the fitted model.
}
\examples{
\donttest{
data(origdata)
data(simdata)
bootVPC(origdata,simdata,N_xbin=8)
}
}
\references{
Post, T. M., et al. (2008)
Extensions to the visual predictive check for facilitate model performance
evaluation, Journal of pharmacokinetics and pharmacodynamics,
35(2), 185-202
}
