% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardReexports.R
\name{bootstrapFit}
\alias{bootstrapFit}
\title{Bootstrap nlmixr2 fit}
\usage{
bootstrapFit(
  fit,
  nboot = 200,
  nSampIndiv,
  stratVar,
  stdErrType = c("perc", "se"),
  ci = 0.95,
  pvalues = NULL,
  restart = FALSE,
  plotHist = FALSE,
  fitName = as.character(substitute(fit))
)
}
\arguments{
\item{fit}{the nlmixr2 fit object}

\item{nboot}{an integer giving the number of bootstrapped models to
be fit; default value is 200}

\item{nSampIndiv}{an integer specifying the number of samples in
each bootstrapped sample; default is the number of unique
subjects in the original dataset}

\item{stratVar}{Variable in the original dataset to stratify on;
This is useful to distinguish between sparse and full sampling
and other features you may wish to keep distinct in your
bootstrap}

\item{stdErrType}{This gives the standard error type for the
updated standard errors; The current possibilities are:
\code{"perc"} which gives the standard errors by percentiles
(default) or \code{"se"} which gives the standard errors by the
traditional formula.}

\item{ci}{Confidence interval level to calculate.  Default is 0.95
for a 95 percent confidence interval}

\item{pvalues}{a vector of pvalues indicating the probability of
each subject to get selected; default value is \code{NULL} implying that
probability of each subject is the same}

\item{restart}{A boolean to try to restart an interrupted or
incomplete boostrap.  By default this is \code{FALSE}}

\item{plotHist}{A boolean indicating if a histogram plot to assess
how well the bootstrap is doing.  By default this is turned off (\code{FALSE})}

\item{fitName}{is the fit name that is used for the name of the
boostrap files.  By default it is the fit provided though it
could be something else.}
}
\value{
Nothing, called for the side effects; The original fit is
updated with the bootstrap confidence bands
}
\description{
Bootstrap input dataset and rerun the model to get confidence bounds and aggregated parameters
}
\examples{
\donttest{

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- 1 # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45
    label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

fit <- nlmixr2(one.cmt, nlmixr2data::theo_sd, "focei")

withr::with_tempdir({ # Run example in temp dir

bootstrapFit(fit, nboot = 5, restart = TRUE) # overwrites any of the existing data or model files
bootstrapFit(fit, nboot = 7) # resumes fitting using the stored data and model files

# Note this resumes because the total number of bootstrap samples is not 50

bootstrapFit(fit, nboot=50)

# Note the boostrap standard error and variance/covariance matrix is retained.
# If you wish to switch back you can change the covariance matrix by

nlmixr2est::setCov(fit,"r,s")

# And change it back again

nlmixr2est::setCov(fit,"boot50")

# This change will affect any simulations with uncertainty in their parameters

# You may also do a chi-square diagnostic plot check for the bootstrap with

bootplot(fit)

})

}
}
\author{
Vipul Mann, Matthew Fidler
}
