% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme.R
\name{nlmixr2NlmeControl}
\alias{nlmixr2NlmeControl}
\alias{nlmeControl}
\title{Control Values for nlme Fit with extra options for nlmixr}
\usage{
nlmixr2NlmeControl(
  maxIter = 100,
  pnlsMaxIter = 100,
  msMaxIter = 100,
  minScale = 0.001,
  tolerance = 1e-05,
  niterEM = 25,
  pnlsTol = 0.001,
  msTol = 1e-06,
  returnObject = FALSE,
  msVerbose = FALSE,
  msWarnNoConv = TRUE,
  gradHess = TRUE,
  apVar = TRUE,
  .relStep = .Machine$double.eps^(1/3),
  minAbsParApVar = 0.05,
  opt = c("nlminb", "nlm"),
  natural = TRUE,
  sigma = NULL,
  optExpression = TRUE,
  sumProd = FALSE,
  rxControl = NULL,
  method = c("ML", "REML"),
  random = NULL,
  fixed = NULL,
  weights = NULL,
  verbose = TRUE,
  returnNlme = FALSE,
  addProp = c("combined2", "combined1"),
  calcTables = TRUE,
  compress = TRUE,
  adjObf = TRUE,
  ci = 0.95,
  sigdig = 4,
  sigdigTable = NULL,
  ...
)

nlmeControl(
  maxIter = 100,
  pnlsMaxIter = 100,
  msMaxIter = 100,
  minScale = 0.001,
  tolerance = 1e-05,
  niterEM = 25,
  pnlsTol = 0.001,
  msTol = 1e-06,
  returnObject = FALSE,
  msVerbose = FALSE,
  msWarnNoConv = TRUE,
  gradHess = TRUE,
  apVar = TRUE,
  .relStep = .Machine$double.eps^(1/3),
  minAbsParApVar = 0.05,
  opt = c("nlminb", "nlm"),
  natural = TRUE,
  sigma = NULL,
  optExpression = TRUE,
  sumProd = FALSE,
  rxControl = NULL,
  method = c("ML", "REML"),
  random = NULL,
  fixed = NULL,
  weights = NULL,
  verbose = TRUE,
  returnNlme = FALSE,
  addProp = c("combined2", "combined1"),
  calcTables = TRUE,
  compress = TRUE,
  adjObf = TRUE,
  ci = 0.95,
  sigdig = 4,
  sigdigTable = NULL,
  ...
)
}
\arguments{
\item{maxIter}{maximum number of iterations for the \code{nlme}
   optimization algorithm.  Default is 50.}

\item{pnlsMaxIter}{maximum number of iterations
   for the \code{PNLS} optimization step inside the \code{nlme}
   optimization.  Default is 7.}

\item{msMaxIter}{maximum number of iterations for \code{\link{nlminb}}
   (\code{iter.max}) or the \code{\link{nlm}} (\code{iterlim}, from the
   10-th step) optimization step inside the \code{nlme}
   optimization.  Default is 50 (which may be too small for e.g. for
   overparametrized cases).}

\item{minScale}{minimum factor by which to shrink the default step size
   in an attempt to decrease the sum of squares in the \code{PNLS} step.
   Default \code{0.001}.}

\item{tolerance}{tolerance for the convergence criterion in the
   \code{nlme} algorithm.  Default is \code{1e-6}.}

\item{niterEM}{number of iterations for the EM algorithm used to refine
   the initial estimates of the random effects variance-covariance
   coefficients.  Default is 25.}

\item{pnlsTol}{tolerance for the convergence criterion in \code{PNLS}
   step.  Default is \code{1e-3}.}

\item{msTol}{tolerance for the convergence criterion in \code{nlm},
   passed as the \code{gradtol} argument to the function (see
   documentation on \code{nlm}).  Default is \code{1e-7}. }

\item{returnObject}{a logical value indicating whether the fitted
   object should be returned when the maximum number of iterations is
   reached without convergence of the algorithm.  Default is
   \code{FALSE}.}

\item{msVerbose}{a logical value passed as the \code{trace} to
   \code{\link{nlminb}(.., control= list(trace = *, ..))} or
   as argument \code{print.level} to \code{\link{nlm}()}.  Default is
   \code{FALSE}.}

\item{msWarnNoConv}{logical indicating if a \code{\link{warning}}
   should be signalled whenever the minimization (by \code{opt}) in the
   LME step does not converge; defaults to \code{TRUE}.}

\item{gradHess}{a logical value indicating whether numerical gradient
   vectors and Hessian matrices of the log-likelihood function should
   be used in the \code{nlm} optimization. This option is only available
   when the correlation structure (\code{corStruct}) and the variance
   function structure (\code{varFunc}) have no "varying" parameters and
   the \code{pdMat} classes used in the random effects structure are
   \code{pdSymm} (general positive-definite), \code{pdDiag} (diagonal),
   \code{pdIdent} (multiple of the identity),  or
   \code{pdCompSymm} (compound symmetry).  Default is \code{TRUE}.}

\item{apVar}{a logical value indicating whether the approximate
   covariance matrix of the variance-covariance parameters should be
   calculated.  Default is \code{TRUE}.}

\item{.relStep}{relative step for numerical derivatives
   calculations.  Default is \code{.Machine$double.eps^(1/3)}.}

\item{minAbsParApVar}{numeric value - minimum absolute parameter value
   in the approximate variance calculation.  The default is \code{0.05}.}

\item{opt}{the optimizer to be used, either \code{"\link{nlminb}"} (the
   default) or \code{"\link{nlm}"}.}

\item{natural}{a logical value indicating whether the \code{pdNatural}
   parametrization should be used for general positive-definite matrices
   (\code{pdSymm}) in \code{reStruct}, when the approximate covariance
   matrix of the estimators is calculated.  Default is \code{TRUE}.}

\item{sigma}{optionally a positive number to fix the residual error at.
   If \code{NULL}, as by default, or \code{0}, sigma is estimated.}

\item{optExpression}{Optimize the rxode2 expression to speed up
calculation. By default this is turned on.}

\item{sumProd}{Is a boolean indicating if the model should change
multiplication to high precision multiplication and sums to
high precision sums using the PreciseSums package.  By default
this is \code{FALSE}.}

\item{rxControl}{`rxode2` ODE solving options during fitting, created with `rxControl()`}

\item{method}{a character string.  If \code{"REML"} the model is fit by
   maximizing the restricted log-likelihood.  If \code{"ML"} the
   log-likelihood is maximized.  Defaults to \code{"ML"}.}

\item{random}{optionally, any of the following: (i) a two-sided formula
   of the form \code{r1+...+rn~x1+...+xm | g1/.../gQ}, with
   \code{r1,...,rn} naming parameters included on the right
   hand side of \code{model}, \code{x1+...+xm} specifying the
   random-effects model for
   these parameters and \code{g1/.../gQ} the grouping structure
   (\code{Q} may be equal to 1, in which case no \code{/} is
   required). The random effects formula will be repeated
   for all levels of grouping, in the case of multiple levels of
   grouping; (ii) a two-sided formula of the form
   \code{r1+...+rn~x1+..+xm}, a list of two-sided formulas of the form
   \code{r1~x1+...+xm}, with possibly different random-effects models
   for different parameters, a \code{pdMat} object with a two-sided
   formula, or list of two-sided formulas (i.e. a non-\code{NULL} value for
   \code{formula(random)}), or a list of pdMat objects with two-sided
   formulas, or lists of two-sided formulas. In this case, the grouping
   structure formula will be given in \code{groups}, or derived from the
   data used to fit the nonlinear mixed-effects model, which should
   inherit from class  \code{groupedData},; (iii) a named list
   of formulas, lists of formulas, or \code{pdMat} objects as in (ii),
   with the grouping factors as names. The order of nesting will be
   assumed the same as the order of the order of the elements in the
   list; (iv) an \code{reStruct} object. See the documentation on
   \code{\link[nlme]{pdClasses}} for a description of the available \code{pdMat}
   classes. Defaults to \code{fixed},
   resulting in all fixed effects having also random effects.}

\item{fixed}{a two-sided linear formula of the form
   \code{f1+...+fn~x1+...+xm}, or a list of two-sided formulas of the form
   \code{f1~x1+...+xm}, with possibly different models for different
   parameters. The \code{f1,...,fn} are the names of parameters included on
   the right hand side of \code{model} and the \code{x1+...+xm}
   expressions define linear models for these parameters (when the left
   hand side of the formula contains several parameters, they all are
   assumed to follow the same linear model, described by the right hand
   side expression).
   A \code{1} on the right hand side of the formula(s) indicates a single
   fixed effects for the corresponding parameter(s).}

\item{weights}{an optional \code{varFunc} object or one-sided formula
   describing the within-group heteroscedasticity structure. If given as
   a formula, it is used as the argument to \code{varFixed},
   corresponding to fixed variance weights. See the documentation on
   \code{\link[nlme]{varClasses}} for a description of the available \code{varFunc}
   classes. Defaults to \code{NULL}, corresponding to homoscedastic
   within-group errors.}

\item{verbose}{an optional logical value. If \code{TRUE} information on
   the evolution of the iterative algorithm is printed. Default is
   \code{FALSE}.}

\item{returnNlme}{Returns the nlme object instead of the nlmixr
object (by default FALSE).  If any of the nlme specific options
of `random`, `fixed`, `sens`, the nlme object is returned}

\item{addProp}{specifies the type of additive plus proportional
  errors, the one where standard deviations add (combined1) or the
  type where the variances add (combined2).

The combined1 error type can be described by the following equation:

  y = f + (a + b*f^c)*err

The combined2 error model can be described by the following equation:

 y = f + sqrt(a^2 + b^2*(f^c)^2)*err

 Where:

 - y represents the observed value

 - f represents the predicted value

 - a  is the additive standard deviation

 - b is the proportional/power standard deviation

 - c is the power exponent (in the proportional case c=1)}

\item{calcTables}{This boolean is to determine if the foceiFit
will calculate tables. By default this is \code{TRUE}}

\item{compress}{Should the object have compressed items}

\item{adjObf}{is a boolean to indicate if the objective function
should be adjusted to be closer to NONMEM's default objective
function.  By default this is \code{TRUE}}

\item{ci}{Confidence level for some tables.  By default this is
0.95 or 95\% confidence.}

\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{sigdigTable}{Significant digits in the final output table.
If not specified, then it matches the significant digits in the
`sigdig` optimization algorithm.  If `sigdig` is NULL, use 3.}

\item{...}{Further, named control arguments to be passed to
   \code{\link{nlminb}} (apart from \code{trace} and \code{iter.max}
   mentioned above), where used (\code{eval.max} and those from
   \code{abs.tol} down).}
}
\value{
a nlmixr-nlme list
}
\description{
The values supplied in the function call replace the defaults and
a list with all possible arguments is returned.  The returned list
is used as the ‘control’ argument to the ‘nlme’ function.
}
\examples{
nlmixr2est::nlmeControl()
nlmixr2NlmeControl()
}
