% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timing.R
\name{nlmixrWithTiming}
\alias{nlmixrWithTiming}
\title{Time a part of a nlmixr operation and add to nlmixr object}
\usage{
nlmixrWithTiming(name, code, envir = NULL)
}
\arguments{
\item{name}{Name of the timing to be integrated}

\item{code}{Code to be evaluated and timed}

\item{envir}{can be either the nlmixr2 fit data, the nlmixr2 fit
environment or NULL, which implies it is going to be added to the
nlmixr fit when it is finalized.  If the function is being called
after a fit is created, please supply this environmental variable}
}
\value{
Result of code
}
\description{
Time a part of a nlmixr operation and add to nlmixr object
}
\examples{

\donttest{

one.cmt <- function() {
 ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}
fit <- nlmixr(one.cmt, theo_sd, est="saem")

nlmixrWithTiming("time1", {
   Sys.sleep(1)
   # note this can be nested, time1 will exclude the timing from time2
   nlmixrWithTiming("time2", {
      Sys.sleep(1)
   }, envir=fit)
}, envir=fit)

print(fit)

}

}
\author{
Matthew L. Fidler
}
