% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSdlf.R
\name{SSdlf}
\alias{SSdlf}
\alias{dlf}
\title{self start for Declining Logistic Function}
\usage{
dlf(time, asym, a2, xmid, scal)

SSdlf(time, asym, a2, xmid, scal)
}
\arguments{
\item{time}{input vector (x) which is normally \sQuote{time}, the smalles value should be close to zero.}

\item{asym}{value of weight or mass at its peak (maximum)}

\item{a2}{value of weight or mass at its trough (minimum)}

\item{xmid}{time at which half of the maximum weight or mass has bean reached.}

\item{scal}{scale parameter which controls the spread also interpreted in terms of time to go from xmid to approx. 0.63 asym}
}
\value{
a numeric vector of the same length as x (time) containing parameter estimates for equation specified

dlf: vector of the same length as x (time) using the declining logistic function
}
\description{
Self starter for declining logistic function with parameters asym, a2, xmid and scal
}
\details{
Response function:  \deqn{y = (asym - a2) / (1 + exp((xmid - time)/scal))) + a2}.

\itemize{
 \item asym: upper asymptote
 \item xmid: time when y is midway between w and a 
 \item scal: controls the spread
 \item a2: lower asymptote 
 }
 
 The four parameter logistic \code{\link{SSfpl}} is essentially equivalent to this function,
 but here the interpretation of the parameters is different and this is the form used in 
 Oddi et. al. (2019) (see vignette).
}
\examples{
\donttest{
## Extended example in the vignette 'nlraa-Oddi-LFMC'
x <- seq(0, 17, by = 0.25)
y <- dlf(x, 2, 10, 8, 1)
plot(x, y, type = "l")
}
}
