% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexplin.R
\name{SSexplin}
\alias{SSexplin}
\alias{explin}
\title{self start for the exponential-linear growth equation}
\usage{
explin(t, cm, rm, tb)

SSexplin(t, cm, rm, tb)
}
\arguments{
\item{t}{input vector (time)}

\item{cm}{parameter related to the maximum growth during the linear phase}

\item{rm}{parameter related to the maximum growth during the exponential phase}

\item{tb}{time at which switch happens}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

explin: vector of the same length as x using a explin function
}
\description{
Self starter for an exponential-linear growth equation
}
\details{
J. GOUDRIAAN, J. L. MONTEITH, A Mathematical Function for Crop Growth Based 
on Light Interception and Leaf Area Expansion, Annals of Botany, Volume 66, 
Issue 6, December 1990, Pages 695–701,
 \url{https://doi.org/10.1093/oxfordjournals.aob.a088084}
 
The equation is: \deqn{ (cm/rm) * log(1 + exp(rm * (t - tb)))}

This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(12345)
x <- seq(1,100, by = 5)
y <- explin(x, 20, 0.14, 30) + rnorm(length(x), 0, 5)
y <- abs(y)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSexplin(x, cm, rm, tb), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
