% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_simulate.R
\name{summary_simulate}
\alias{summary_simulate}
\title{Summarize a matrix of simulations by their mean (median), sd (mad), and quantiles}
\usage{
summary_simulate(
  object,
  probs = c(0.025, 0.975),
  robust = FALSE,
  data,
  by,
  ...
)
}
\arguments{
\item{object}{nobs x nsim matrix where nobs are the number of observations in the
dataset and nsim are the number of simulations}

\item{probs}{the percentiles to be computed by the quantile function}

\item{robust}{If FALSE (the default) the mean is used as the measure of central tendency 
and the standard deviation as the measure of variability. 
If TRUE, the median and the median absolute deviation (MAD) are applied instead.}

\item{data}{the original data.frame used to fit the model. A data.frame will be
returned instead of a matrix in this case.}

\item{by}{opionally aggregate the results by some factor in the data.frame. It 
will be coarced to a formula. This should either be a character or a formula (starting with \sQuote{~}).
The aggregation follows the \sQuote{robust} argument above.}

\item{...}{additional arguments to be passed. (none used at the moment)}
}
\value{
By default it returns a matrix unless the \sQuote{data} argument is present and then
it will return a data.frame
}
\description{
Utility function to summarize the output from \sQuote{simulate} 
functions in this package
}
\examples{
\donttest{
data(barley, package = "nlraa")
fit <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)
sim <- simulate_nls(fit, nsim = 100)
sims <- summary_simulate(sim)

## If we want to combine the data.frame
simd <- summary_simulate(sim, data = barley)
## If we also want to aggregate by nitrogen rate
simda <- summary_simulate(sim, data = barley, by = "NF")
## The robust option uses the median instead
simdar <- summary_simulate(sim, data = barley, by = "NF",
                           robust = TRUE)

}

}
