% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_INLA_dat.R
\name{create_INLA_dat}
\alias{create_INLA_dat}
\title{Prepare network meta-analysis dataset for INLA.}
\usage{
create_INLA_dat(dat = dat, armVars = c(treatment = "t", responders = "r",
  sampleSize = "n"), covariate = "cov", design = "des", nArmsVar = "na")
}
\arguments{
\item{dat}{Data in one-study-per-row format.}

\item{armVars}{Vector of per-arm variables
The name of each component will be the column name in the resulting dataset.}

\item{covariate}{Optional. Vector of study-specific covariate}

\item{design}{Optional. Vector of study-specific design. We refer design for
the set of treatments in each trial.}

\item{nArmsVar}{Variable holding the number of arms for each study.}
}
\value{
A data frame with the generated coloumns.
}
\description{
\code{create_INLA_dat} converts datasets in the one-study-per-row format to one-arm-per-row format
, then adds indicator (dummy) variables for the basic contrasts,
heterogeneity random effects and design-specific inconsistency random effects and for
correlated multi-arm trials.
}
\details{
The resulting data.frame can be used as data argument in \code{nma_inla}.
}
\examples{
data('Smokdat')
## Create the dataset suitable for INLA
SmokdatINLA <- create_INLA_dat(dat = Smokdat, armVars = c('treatment' = 't', 'responders' = 'r'
,'sampleSize' = 'n'), nArmsVar = 'na')
## Check that the data are correct
print(SmokdatINLA)
}
\seealso{
\code{gemtc::mtc.data.studyrow}
}
\author{
Burak Kuersad Guenhan, \email{burak.gunhan@med.uni-goettingen.de},
Rafael Sauter and Gert van Valkenhoef
}
