% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqRes.r
\name{rqresiduals}
\alias{rqresiduals}
\title{Randomized quantile resiudals for binomial N-mixture models.}
\usage{
rqresiduals(umFit, type = "marginal")
}
\arguments{
\item{umFit}{An object of class \link[unmarked]{unmarkedFit} from a model fitted using \link[unmarked]{pcount}.}

\item{type}{The type of rq residuals to compute, one of 'marginal', 'site-sum' or 'observation'.}
}
\value{
A matrix (if \code{type} is 'marginal' or 'site-sum') or vector (for )  con.
}
\description{
Computes three types of randomized quantile residuals for binomial N-mixture models.
}
\examples{
library(unmarked)
umf = unmarkedFramePCount(y = shoveler$y, obsCovs = shoveler$obs, siteCovs = shoveler$site)
fmP = pcount(~scale(date) + scale(reedcover) ~ scale(log(water)) + scale(latitude), 
      data = umf, K = 80)
qqnorm(rqresiduals(fmP, "s"))
qqnorm(rqresiduals(fmP, "o"))
par(mfcol = c(3,4))
invisible(apply(rqresiduals(fmP, "m"), 2, qqnorm))
}
