% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{maxle_p}
\alias{maxle_p}
\title{\code{maxle_p} returns expression of partitioned log-likelihood.
 f(y1,y2,..,yn)=f(y1)f(y2|y1)f(y3|y2y1)...f(yn|y1..y(n-1))}
\usage{
maxle_p(cheqs0, fixed_term = TRUE, version2 = TRUE)
}
\arguments{
\item{cheqs0}{Strings defining equations of errors.}

\item{fixed_term}{if \code{TRUE} fixed term -(k/2)*log(2*pi) (k number of equations) is included}

\item{version2}{another formulation of log-likelihood}
}
\value{
List. First element is expression of joint distribution for derivatives,
second for evaluation, third latex, fourth marginal distributions for each variable.
}
\description{
\code{maxle_p} returns expression of partitioned log-likelihood.
 f(y1,y2,..,yn)=f(y1)f(y2|y1)f(y3|y2y1)...f(yn|y1..y(n-1))
}
\examples{
# joint normal distribution
eq_c <- c("Tw ~ ((((PH) + (tw)) * (ta - Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) -(1 + (PH))) +
 sqrt((((PH) + (tw)) * (ta - Tc + 2) + (1 +(tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 - 4 * (1 + (PH) +
  (tw)) *(-(PH) * (ta - Tc + 2) + (1 - (tw) * (ta - Tc + 2)) * (2/w -Ec/w))))/(2 * (1 + (PH) +
   (tw)))",
"Tf1 ~ (th1) * (ta - (((((PH) + (tw)) * (ta - Tc + 2) + (1 + (tw)) *(Ec/w - 2/w) - (1 + (PH))) +
 sqrt((((PH) + (tw)) * (ta -Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 - 4 *(1 + (PH) +
  (tw)) * (-(PH) * (ta - Tc + 2) + (1 - (tw) *(ta - Tc + 2)) * (2/w - Ec/w))))/(2 * (1 + (PH) +
   (tw)))) -Tc + 2) - 1",
"Ef1 ~ (ph1)/(PH) * (w * (((((PH) + (tw)) * (ta - Tc + 2) + (1 +(tw)) * (Ec/w - 2/w) - (1 +
 (PH))) + sqrt((((PH) + (tw)) *(ta - Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 -4 *
  (1 + (PH) + (tw)) * (-(PH) * (ta - Tc + 2) + (1 - (tw) *(ta - Tc + 2)) * (2/w - Ec/w))))/(2 *
  (1 + (PH) + (tw)))) -Ec + 2) - 1")
parl <- c("tw","PH","th1","ph1")
para_cont <- get_par(parl, eq_c)
cheqs0 <- para_cont$cheqs0
res <- maxle_p(cheqs0=cheqs0)
}
